# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ReportDetails(object):
    """
    fetch reports for FAM based on filter.
    """

    #: A constant which can be used with the granularity property of a ReportDetails.
    #: This constant has a value of "DAY"
    GRANULARITY_DAY = "DAY"

    #: A constant which can be used with the granularity property of a ReportDetails.
    #: This constant has a value of "WEEK"
    GRANULARITY_WEEK = "WEEK"

    #: A constant which can be used with the granularity property of a ReportDetails.
    #: This constant has a value of "MONTH"
    GRANULARITY_MONTH = "MONTH"

    #: A constant which can be used with the granularity property of a ReportDetails.
    #: This constant has a value of "QUARTER"
    GRANULARITY_QUARTER = "QUARTER"

    #: A constant which can be used with the granularity property of a ReportDetails.
    #: This constant has a value of "YEAR"
    GRANULARITY_YEAR = "YEAR"

    #: A constant which can be used with the condition property of a ReportDetails.
    #: This constant has a value of "ALL"
    CONDITION_ALL = "ALL"

    #: A constant which can be used with the condition property of a ReportDetails.
    #: This constant has a value of "ANY"
    CONDITION_ANY = "ANY"

    def __init__(self, **kwargs):
        """
        Initializes a new ReportDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this ReportDetails.
        :type name: str

        :param granularity:
            The value to assign to the granularity property of this ReportDetails.
            Allowed values for this property are: "DAY", "WEEK", "MONTH", "QUARTER", "YEAR"
        :type granularity: str

        :param report_time_range:
            The value to assign to the report_time_range property of this ReportDetails.
        :type report_time_range: oci.fleet_apps_management.models.ReportTimeRange

        :param condition:
            The value to assign to the condition property of this ReportDetails.
            Allowed values for this property are: "ALL", "ANY"
        :type condition: str

        :param filters:
            The value to assign to the filters property of this ReportDetails.
        :type filters: list[oci.fleet_apps_management.models.Filter]

        :param order_clause:
            The value to assign to the order_clause property of this ReportDetails.
        :type order_clause: list[oci.fleet_apps_management.models.OrderClause]

        """
        self.swagger_types = {
            'name': 'str',
            'granularity': 'str',
            'report_time_range': 'ReportTimeRange',
            'condition': 'str',
            'filters': 'list[Filter]',
            'order_clause': 'list[OrderClause]'
        }
        self.attribute_map = {
            'name': 'name',
            'granularity': 'granularity',
            'report_time_range': 'reportTimeRange',
            'condition': 'condition',
            'filters': 'filters',
            'order_clause': 'orderClause'
        }
        self._name = None
        self._granularity = None
        self._report_time_range = None
        self._condition = None
        self._filters = None
        self._order_clause = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this ReportDetails.
        Name of report.


        :return: The name of this ReportDetails.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ReportDetails.
        Name of report.


        :param name: The name of this ReportDetails.
        :type: str
        """
        self._name = name

    @property
    def granularity(self):
        """
        Gets the granularity of this ReportDetails.
        Granularity.

        Allowed values for this property are: "DAY", "WEEK", "MONTH", "QUARTER", "YEAR"


        :return: The granularity of this ReportDetails.
        :rtype: str
        """
        return self._granularity

    @granularity.setter
    def granularity(self, granularity):
        """
        Sets the granularity of this ReportDetails.
        Granularity.


        :param granularity: The granularity of this ReportDetails.
        :type: str
        """
        allowed_values = ["DAY", "WEEK", "MONTH", "QUARTER", "YEAR"]
        if not value_allowed_none_or_none_sentinel(granularity, allowed_values):
            raise ValueError(
                f"Invalid value for `granularity`, must be None or one of {allowed_values}"
            )
        self._granularity = granularity

    @property
    def report_time_range(self):
        """
        Gets the report_time_range of this ReportDetails.

        :return: The report_time_range of this ReportDetails.
        :rtype: oci.fleet_apps_management.models.ReportTimeRange
        """
        return self._report_time_range

    @report_time_range.setter
    def report_time_range(self, report_time_range):
        """
        Sets the report_time_range of this ReportDetails.

        :param report_time_range: The report_time_range of this ReportDetails.
        :type: oci.fleet_apps_management.models.ReportTimeRange
        """
        self._report_time_range = report_time_range

    @property
    def condition(self):
        """
        Gets the condition of this ReportDetails.
        Condition.

        Allowed values for this property are: "ALL", "ANY"


        :return: The condition of this ReportDetails.
        :rtype: str
        """
        return self._condition

    @condition.setter
    def condition(self, condition):
        """
        Sets the condition of this ReportDetails.
        Condition.


        :param condition: The condition of this ReportDetails.
        :type: str
        """
        allowed_values = ["ALL", "ANY"]
        if not value_allowed_none_or_none_sentinel(condition, allowed_values):
            raise ValueError(
                f"Invalid value for `condition`, must be None or one of {allowed_values}"
            )
        self._condition = condition

    @property
    def filters(self):
        """
        Gets the filters of this ReportDetails.
        Filters for reports.


        :return: The filters of this ReportDetails.
        :rtype: list[oci.fleet_apps_management.models.Filter]
        """
        return self._filters

    @filters.setter
    def filters(self, filters):
        """
        Sets the filters of this ReportDetails.
        Filters for reports.


        :param filters: The filters of this ReportDetails.
        :type: list[oci.fleet_apps_management.models.Filter]
        """
        self._filters = filters

    @property
    def order_clause(self):
        """
        Gets the order_clause of this ReportDetails.
        order clauses for reports.


        :return: The order_clause of this ReportDetails.
        :rtype: list[oci.fleet_apps_management.models.OrderClause]
        """
        return self._order_clause

    @order_clause.setter
    def order_clause(self, order_clause):
        """
        Sets the order_clause of this ReportDetails.
        order clauses for reports.


        :param order_clause: The order_clause of this ReportDetails.
        :type: list[oci.fleet_apps_management.models.OrderClause]
        """
        self._order_clause = order_clause

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
