# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SchemaDocument(object):
    """
    Schema Document representing Schema.yaml (/iaas/Content/ResourceManager/Concepts/terraformconfigresourcemanager_topic-schema.htm)
    """

    #: A constant which can be used with the schema_version property of a SchemaDocument.
    #: This constant has a value of "V_1_0_0"
    SCHEMA_VERSION_V_1_0_0 = "V_1_0_0"

    #: A constant which can be used with the schema_version property of a SchemaDocument.
    #: This constant has a value of "V_1_1_0"
    SCHEMA_VERSION_V_1_1_0 = "V_1_1_0"

    #: A constant which can be used with the locale property of a SchemaDocument.
    #: This constant has a value of "EN"
    LOCALE_EN = "EN"

    def __init__(self, **kwargs):
        """
        Initializes a new SchemaDocument object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param title:
            The value to assign to the title property of this SchemaDocument.
        :type title: str

        :param description:
            The value to assign to the description property of this SchemaDocument.
        :type description: str

        :param stack_description:
            The value to assign to the stack_description property of this SchemaDocument.
        :type stack_description: str

        :param package_version:
            The value to assign to the package_version property of this SchemaDocument.
        :type package_version: str

        :param version:
            The value to assign to the version property of this SchemaDocument.
        :type version: str

        :param schema_version:
            The value to assign to the schema_version property of this SchemaDocument.
            Allowed values for this property are: "V_1_0_0", "V_1_1_0", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type schema_version: str

        :param locale:
            The value to assign to the locale property of this SchemaDocument.
            Allowed values for this property are: "EN", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type locale: str

        :param logo_url:
            The value to assign to the logo_url property of this SchemaDocument.
        :type logo_url: str

        :param source:
            The value to assign to the source property of this SchemaDocument.
        :type source: oci.fleet_apps_management.models.StackSource

        :param informational_text:
            The value to assign to the informational_text property of this SchemaDocument.
        :type informational_text: str

        :param instructions:
            The value to assign to the instructions property of this SchemaDocument.
        :type instructions: str

        :param troubleshooting:
            The value to assign to the troubleshooting property of this SchemaDocument.
        :type troubleshooting: str

        :param can_allow_view_state:
            The value to assign to the can_allow_view_state property of this SchemaDocument.
        :type can_allow_view_state: bool

        :param variables:
            The value to assign to the variables property of this SchemaDocument.
        :type variables: dict(str, BaseVariable)

        :param groupings:
            The value to assign to the groupings property of this SchemaDocument.
        :type groupings: oci.fleet_apps_management.models.VariableGroups

        :param variable_groups:
            The value to assign to the variable_groups property of this SchemaDocument.
        :type variable_groups: list[oci.fleet_apps_management.models.VariableGroup]

        :param outputs:
            The value to assign to the outputs property of this SchemaDocument.
        :type outputs: dict(str, BaseOutput)

        :param output_groups:
            The value to assign to the output_groups property of this SchemaDocument.
        :type output_groups: list[oci.fleet_apps_management.models.OutputGroup]

        :param primary_output_button:
            The value to assign to the primary_output_button property of this SchemaDocument.
        :type primary_output_button: str

        """
        self.swagger_types = {
            'title': 'str',
            'description': 'str',
            'stack_description': 'str',
            'package_version': 'str',
            'version': 'str',
            'schema_version': 'str',
            'locale': 'str',
            'logo_url': 'str',
            'source': 'StackSource',
            'informational_text': 'str',
            'instructions': 'str',
            'troubleshooting': 'str',
            'can_allow_view_state': 'bool',
            'variables': 'dict(str, BaseVariable)',
            'groupings': 'VariableGroups',
            'variable_groups': 'list[VariableGroup]',
            'outputs': 'dict(str, BaseOutput)',
            'output_groups': 'list[OutputGroup]',
            'primary_output_button': 'str'
        }
        self.attribute_map = {
            'title': 'title',
            'description': 'description',
            'stack_description': 'stackDescription',
            'package_version': 'packageVersion',
            'version': 'version',
            'schema_version': 'schemaVersion',
            'locale': 'locale',
            'logo_url': 'logoUrl',
            'source': 'source',
            'informational_text': 'informationalText',
            'instructions': 'instructions',
            'troubleshooting': 'troubleshooting',
            'can_allow_view_state': 'canAllowViewState',
            'variables': 'variables',
            'groupings': 'groupings',
            'variable_groups': 'variableGroups',
            'outputs': 'outputs',
            'output_groups': 'outputGroups',
            'primary_output_button': 'primaryOutputButton'
        }
        self._title = None
        self._description = None
        self._stack_description = None
        self._package_version = None
        self._version = None
        self._schema_version = None
        self._locale = None
        self._logo_url = None
        self._source = None
        self._informational_text = None
        self._instructions = None
        self._troubleshooting = None
        self._can_allow_view_state = None
        self._variables = None
        self._groupings = None
        self._variable_groups = None
        self._outputs = None
        self._output_groups = None
        self._primary_output_button = None

    @property
    def title(self):
        """
        Gets the title of this SchemaDocument.
        The display name or title for this schema document.


        :return: The title of this SchemaDocument.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """
        Sets the title of this SchemaDocument.
        The display name or title for this schema document.


        :param title: The title of this SchemaDocument.
        :type: str
        """
        self._title = title

    @property
    def description(self):
        """
        Gets the description of this SchemaDocument.
        A detailed description of the stack or schema.


        :return: The description of this SchemaDocument.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this SchemaDocument.
        A detailed description of the stack or schema.


        :param description: The description of this SchemaDocument.
        :type: str
        """
        self._description = description

    @property
    def stack_description(self):
        """
        Gets the stack_description of this SchemaDocument.
        Additional details describing the stack's purpose or use-case.


        :return: The stack_description of this SchemaDocument.
        :rtype: str
        """
        return self._stack_description

    @stack_description.setter
    def stack_description(self, stack_description):
        """
        Sets the stack_description of this SchemaDocument.
        Additional details describing the stack's purpose or use-case.


        :param stack_description: The stack_description of this SchemaDocument.
        :type: str
        """
        self._stack_description = stack_description

    @property
    def package_version(self):
        """
        Gets the package_version of this SchemaDocument.
        The version of the package associated with this schema.


        :return: The package_version of this SchemaDocument.
        :rtype: str
        """
        return self._package_version

    @package_version.setter
    def package_version(self, package_version):
        """
        Sets the package_version of this SchemaDocument.
        The version of the package associated with this schema.


        :param package_version: The package_version of this SchemaDocument.
        :type: str
        """
        self._package_version = package_version

    @property
    def version(self):
        """
        Gets the version of this SchemaDocument.
        The version identifier for this schema document.


        :return: The version of this SchemaDocument.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this SchemaDocument.
        The version identifier for this schema document.


        :param version: The version of this SchemaDocument.
        :type: str
        """
        self._version = version

    @property
    def schema_version(self):
        """
        **[Required]** Gets the schema_version of this SchemaDocument.
        The version of the schema definition format in use for this document.

        Allowed values for this property are: "V_1_0_0", "V_1_1_0", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The schema_version of this SchemaDocument.
        :rtype: str
        """
        return self._schema_version

    @schema_version.setter
    def schema_version(self, schema_version):
        """
        Sets the schema_version of this SchemaDocument.
        The version of the schema definition format in use for this document.


        :param schema_version: The schema_version of this SchemaDocument.
        :type: str
        """
        allowed_values = ["V_1_0_0", "V_1_1_0"]
        if not value_allowed_none_or_none_sentinel(schema_version, allowed_values):
            schema_version = 'UNKNOWN_ENUM_VALUE'
        self._schema_version = schema_version

    @property
    def locale(self):
        """
        Gets the locale of this SchemaDocument.
        The locale/language for the schema user interface (default is EN).

        Allowed values for this property are: "EN", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The locale of this SchemaDocument.
        :rtype: str
        """
        return self._locale

    @locale.setter
    def locale(self, locale):
        """
        Sets the locale of this SchemaDocument.
        The locale/language for the schema user interface (default is EN).


        :param locale: The locale of this SchemaDocument.
        :type: str
        """
        allowed_values = ["EN"]
        if not value_allowed_none_or_none_sentinel(locale, allowed_values):
            locale = 'UNKNOWN_ENUM_VALUE'
        self._locale = locale

    @property
    def logo_url(self):
        """
        Gets the logo_url of this SchemaDocument.
        logo url.


        :return: The logo_url of this SchemaDocument.
        :rtype: str
        """
        return self._logo_url

    @logo_url.setter
    def logo_url(self, logo_url):
        """
        Sets the logo_url of this SchemaDocument.
        logo url.


        :param logo_url: The logo_url of this SchemaDocument.
        :type: str
        """
        self._logo_url = logo_url

    @property
    def source(self):
        """
        Gets the source of this SchemaDocument.

        :return: The source of this SchemaDocument.
        :rtype: oci.fleet_apps_management.models.StackSource
        """
        return self._source

    @source.setter
    def source(self, source):
        """
        Sets the source of this SchemaDocument.

        :param source: The source of this SchemaDocument.
        :type: oci.fleet_apps_management.models.StackSource
        """
        self._source = source

    @property
    def informational_text(self):
        """
        Gets the informational_text of this SchemaDocument.
        Informational text or notes relevant to the stack or its use.


        :return: The informational_text of this SchemaDocument.
        :rtype: str
        """
        return self._informational_text

    @informational_text.setter
    def informational_text(self, informational_text):
        """
        Sets the informational_text of this SchemaDocument.
        Informational text or notes relevant to the stack or its use.


        :param informational_text: The informational_text of this SchemaDocument.
        :type: str
        """
        self._informational_text = informational_text

    @property
    def instructions(self):
        """
        Gets the instructions of this SchemaDocument.
        Setup or usage instructions for this stack.


        :return: The instructions of this SchemaDocument.
        :rtype: str
        """
        return self._instructions

    @instructions.setter
    def instructions(self, instructions):
        """
        Sets the instructions of this SchemaDocument.
        Setup or usage instructions for this stack.


        :param instructions: The instructions of this SchemaDocument.
        :type: str
        """
        self._instructions = instructions

    @property
    def troubleshooting(self):
        """
        Gets the troubleshooting of this SchemaDocument.
        Troubleshooting tips, guidance, or steps for stack usage.


        :return: The troubleshooting of this SchemaDocument.
        :rtype: str
        """
        return self._troubleshooting

    @troubleshooting.setter
    def troubleshooting(self, troubleshooting):
        """
        Sets the troubleshooting of this SchemaDocument.
        Troubleshooting tips, guidance, or steps for stack usage.


        :param troubleshooting: The troubleshooting of this SchemaDocument.
        :type: str
        """
        self._troubleshooting = troubleshooting

    @property
    def can_allow_view_state(self):
        """
        Gets the can_allow_view_state of this SchemaDocument.
        Indicates if the stack allows users to view state information.


        :return: The can_allow_view_state of this SchemaDocument.
        :rtype: bool
        """
        return self._can_allow_view_state

    @can_allow_view_state.setter
    def can_allow_view_state(self, can_allow_view_state):
        """
        Sets the can_allow_view_state of this SchemaDocument.
        Indicates if the stack allows users to view state information.


        :param can_allow_view_state: The can_allow_view_state of this SchemaDocument.
        :type: bool
        """
        self._can_allow_view_state = can_allow_view_state

    @property
    def variables(self):
        """
        **[Required]** Gets the variables of this SchemaDocument.
        Key-value map of input variables defined for use by the stack.


        :return: The variables of this SchemaDocument.
        :rtype: dict(str, BaseVariable)
        """
        return self._variables

    @variables.setter
    def variables(self, variables):
        """
        Sets the variables of this SchemaDocument.
        Key-value map of input variables defined for use by the stack.


        :param variables: The variables of this SchemaDocument.
        :type: dict(str, BaseVariable)
        """
        self._variables = variables

    @property
    def groupings(self):
        """
        Gets the groupings of this SchemaDocument.

        :return: The groupings of this SchemaDocument.
        :rtype: oci.fleet_apps_management.models.VariableGroups
        """
        return self._groupings

    @groupings.setter
    def groupings(self, groupings):
        """
        Sets the groupings of this SchemaDocument.

        :param groupings: The groupings of this SchemaDocument.
        :type: oci.fleet_apps_management.models.VariableGroups
        """
        self._groupings = groupings

    @property
    def variable_groups(self):
        """
        Gets the variable_groups of this SchemaDocument.
        An array of variable group definitions for organizing variables together.


        :return: The variable_groups of this SchemaDocument.
        :rtype: list[oci.fleet_apps_management.models.VariableGroup]
        """
        return self._variable_groups

    @variable_groups.setter
    def variable_groups(self, variable_groups):
        """
        Sets the variable_groups of this SchemaDocument.
        An array of variable group definitions for organizing variables together.


        :param variable_groups: The variable_groups of this SchemaDocument.
        :type: list[oci.fleet_apps_management.models.VariableGroup]
        """
        self._variable_groups = variable_groups

    @property
    def outputs(self):
        """
        Gets the outputs of this SchemaDocument.
        A mapping of output variable names to their definitions.


        :return: The outputs of this SchemaDocument.
        :rtype: dict(str, BaseOutput)
        """
        return self._outputs

    @outputs.setter
    def outputs(self, outputs):
        """
        Sets the outputs of this SchemaDocument.
        A mapping of output variable names to their definitions.


        :param outputs: The outputs of this SchemaDocument.
        :type: dict(str, BaseOutput)
        """
        self._outputs = outputs

    @property
    def output_groups(self):
        """
        Gets the output_groups of this SchemaDocument.
        Array of output group objects to group outputs for display or logical purposes.


        :return: The output_groups of this SchemaDocument.
        :rtype: list[oci.fleet_apps_management.models.OutputGroup]
        """
        return self._output_groups

    @output_groups.setter
    def output_groups(self, output_groups):
        """
        Sets the output_groups of this SchemaDocument.
        Array of output group objects to group outputs for display or logical purposes.


        :param output_groups: The output_groups of this SchemaDocument.
        :type: list[oci.fleet_apps_management.models.OutputGroup]
        """
        self._output_groups = output_groups

    @property
    def primary_output_button(self):
        """
        Gets the primary_output_button of this SchemaDocument.
        primary output button value.


        :return: The primary_output_button of this SchemaDocument.
        :rtype: str
        """
        return self._primary_output_button

    @primary_output_button.setter
    def primary_output_button(self, primary_output_button):
        """
        Sets the primary_output_button of this SchemaDocument.
        primary output button value.


        :param primary_output_button: The primary_output_button of this SchemaDocument.
        :type: str
        """
        self._primary_output_button = primary_output_button

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
