# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220528

from .update_fsu_cycle_details import UpdateFsuCycleDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdatePatchFsuCycle(UpdateFsuCycleDetails):
    """
    Update Patch Exadata Fleet Update Cycle resource details.
    If automated maintenance is enabled for the associated Exadata Fleet Update Collection, updating Exadata Fleet Update Cycle will not affect the Exadata Fleet Update Collection.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdatePatchFsuCycle object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_software_update.models.UpdatePatchFsuCycle.type` attribute
        of this class is ``PATCH`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this UpdatePatchFsuCycle.
        :type display_name: str

        :param type:
            The value to assign to the type property of this UpdatePatchFsuCycle.
            Allowed values for this property are: "PATCH", "UPGRADE"
        :type type: str

        :param goal_version_details:
            The value to assign to the goal_version_details property of this UpdatePatchFsuCycle.
        :type goal_version_details: oci.fleet_software_update.models.FsuGoalVersionDetails

        :param batching_strategy:
            The value to assign to the batching_strategy property of this UpdatePatchFsuCycle.
        :type batching_strategy: oci.fleet_software_update.models.UpdateBatchingStrategyDetails

        :param diagnostics_collection:
            The value to assign to the diagnostics_collection property of this UpdatePatchFsuCycle.
        :type diagnostics_collection: oci.fleet_software_update.models.DiagnosticsCollectionDetails

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdatePatchFsuCycle.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdatePatchFsuCycle.
        :type defined_tags: dict(str, dict(str, object))

        :param is_ignore_patches:
            The value to assign to the is_ignore_patches property of this UpdatePatchFsuCycle.
        :type is_ignore_patches: bool

        :param is_ignore_missing_patches:
            The value to assign to the is_ignore_missing_patches property of this UpdatePatchFsuCycle.
        :type is_ignore_missing_patches: list[str]

        :param max_drain_timeout_in_seconds:
            The value to assign to the max_drain_timeout_in_seconds property of this UpdatePatchFsuCycle.
        :type max_drain_timeout_in_seconds: int

        :param is_keep_placement:
            The value to assign to the is_keep_placement property of this UpdatePatchFsuCycle.
        :type is_keep_placement: bool

        """
        self.swagger_types = {
            'display_name': 'str',
            'type': 'str',
            'goal_version_details': 'FsuGoalVersionDetails',
            'batching_strategy': 'UpdateBatchingStrategyDetails',
            'diagnostics_collection': 'DiagnosticsCollectionDetails',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'is_ignore_patches': 'bool',
            'is_ignore_missing_patches': 'list[str]',
            'max_drain_timeout_in_seconds': 'int',
            'is_keep_placement': 'bool'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'type': 'type',
            'goal_version_details': 'goalVersionDetails',
            'batching_strategy': 'batchingStrategy',
            'diagnostics_collection': 'diagnosticsCollection',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'is_ignore_patches': 'isIgnorePatches',
            'is_ignore_missing_patches': 'isIgnoreMissingPatches',
            'max_drain_timeout_in_seconds': 'maxDrainTimeoutInSeconds',
            'is_keep_placement': 'isKeepPlacement'
        }
        self._display_name = None
        self._type = None
        self._goal_version_details = None
        self._batching_strategy = None
        self._diagnostics_collection = None
        self._freeform_tags = None
        self._defined_tags = None
        self._is_ignore_patches = None
        self._is_ignore_missing_patches = None
        self._max_drain_timeout_in_seconds = None
        self._is_keep_placement = None
        self._type = 'PATCH'

    @property
    def is_ignore_patches(self):
        """
        Gets the is_ignore_patches of this UpdatePatchFsuCycle.
        Ignore patch conflicts or missing patches between the source and goal homes.
        This attribute will be ignored for Exadata Image (Guest OS) maintenance update.


        :return: The is_ignore_patches of this UpdatePatchFsuCycle.
        :rtype: bool
        """
        return self._is_ignore_patches

    @is_ignore_patches.setter
    def is_ignore_patches(self, is_ignore_patches):
        """
        Sets the is_ignore_patches of this UpdatePatchFsuCycle.
        Ignore patch conflicts or missing patches between the source and goal homes.
        This attribute will be ignored for Exadata Image (Guest OS) maintenance update.


        :param is_ignore_patches: The is_ignore_patches of this UpdatePatchFsuCycle.
        :type: bool
        """
        self._is_ignore_patches = is_ignore_patches

    @property
    def is_ignore_missing_patches(self):
        """
        Gets the is_ignore_missing_patches of this UpdatePatchFsuCycle.
        List of identifiers of patches to ignore.
        Specify an empty array to unset the field.
        This attribute will be ignored for Exadata Image (Guest OS) maintenance update.


        :return: The is_ignore_missing_patches of this UpdatePatchFsuCycle.
        :rtype: list[str]
        """
        return self._is_ignore_missing_patches

    @is_ignore_missing_patches.setter
    def is_ignore_missing_patches(self, is_ignore_missing_patches):
        """
        Sets the is_ignore_missing_patches of this UpdatePatchFsuCycle.
        List of identifiers of patches to ignore.
        Specify an empty array to unset the field.
        This attribute will be ignored for Exadata Image (Guest OS) maintenance update.


        :param is_ignore_missing_patches: The is_ignore_missing_patches of this UpdatePatchFsuCycle.
        :type: list[str]
        """
        self._is_ignore_missing_patches = is_ignore_missing_patches

    @property
    def max_drain_timeout_in_seconds(self):
        """
        Gets the max_drain_timeout_in_seconds of this UpdatePatchFsuCycle.
        Timeout for session draining for database services specified in seconds.


        :return: The max_drain_timeout_in_seconds of this UpdatePatchFsuCycle.
        :rtype: int
        """
        return self._max_drain_timeout_in_seconds

    @max_drain_timeout_in_seconds.setter
    def max_drain_timeout_in_seconds(self, max_drain_timeout_in_seconds):
        """
        Sets the max_drain_timeout_in_seconds of this UpdatePatchFsuCycle.
        Timeout for session draining for database services specified in seconds.


        :param max_drain_timeout_in_seconds: The max_drain_timeout_in_seconds of this UpdatePatchFsuCycle.
        :type: int
        """
        self._max_drain_timeout_in_seconds = max_drain_timeout_in_seconds

    @property
    def is_keep_placement(self):
        """
        Gets the is_keep_placement of this UpdatePatchFsuCycle.
        Ensure that database services are online on the same VMs before and after the maintenance update.


        :return: The is_keep_placement of this UpdatePatchFsuCycle.
        :rtype: bool
        """
        return self._is_keep_placement

    @is_keep_placement.setter
    def is_keep_placement(self, is_keep_placement):
        """
        Sets the is_keep_placement of this UpdatePatchFsuCycle.
        Ensure that database services are online on the same VMs before and after the maintenance update.


        :param is_keep_placement: The is_keep_placement of this UpdatePatchFsuCycle.
        :type: bool
        """
        self._is_keep_placement = is_keep_placement

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
