# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531

from .performed_action import PerformedAction
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class HumanApprovalPerformedAction(PerformedAction):
    """
    An action describing user approval to the agent.
    """

    #: A constant which can be used with the chosen_option property of a HumanApprovalPerformedAction.
    #: This constant has a value of "APPROVE"
    CHOSEN_OPTION_APPROVE = "APPROVE"

    #: A constant which can be used with the chosen_option property of a HumanApprovalPerformedAction.
    #: This constant has a value of "DENY"
    CHOSEN_OPTION_DENY = "DENY"

    def __init__(self, **kwargs):
        """
        Initializes a new HumanApprovalPerformedAction object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_agent_runtime.models.HumanApprovalPerformedAction.performed_action_type` attribute
        of this class is ``HUMAN_APPROVAL_PERFORMED_ACTION`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param action_id:
            The value to assign to the action_id property of this HumanApprovalPerformedAction.
        :type action_id: str

        :param performed_action_type:
            The value to assign to the performed_action_type property of this HumanApprovalPerformedAction.
            Allowed values for this property are: "HUMAN_APPROVAL_PERFORMED_ACTION", "FUNCTION_CALLING_PERFORMED_ACTION"
        :type performed_action_type: str

        :param chosen_option:
            The value to assign to the chosen_option property of this HumanApprovalPerformedAction.
            Allowed values for this property are: "APPROVE", "DENY"
        :type chosen_option: str

        """
        self.swagger_types = {
            'action_id': 'str',
            'performed_action_type': 'str',
            'chosen_option': 'str'
        }
        self.attribute_map = {
            'action_id': 'actionId',
            'performed_action_type': 'performedActionType',
            'chosen_option': 'chosenOption'
        }
        self._action_id = None
        self._performed_action_type = None
        self._chosen_option = None
        self._performed_action_type = 'HUMAN_APPROVAL_PERFORMED_ACTION'

    @property
    def chosen_option(self):
        """
        **[Required]** Gets the chosen_option of this HumanApprovalPerformedAction.
        The chosen approval or denial option to the agent.

        Allowed values for this property are: "APPROVE", "DENY"


        :return: The chosen_option of this HumanApprovalPerformedAction.
        :rtype: str
        """
        return self._chosen_option

    @chosen_option.setter
    def chosen_option(self, chosen_option):
        """
        Sets the chosen_option of this HumanApprovalPerformedAction.
        The chosen approval or denial option to the agent.


        :param chosen_option: The chosen_option of this HumanApprovalPerformedAction.
        :type: str
        """
        allowed_values = ["APPROVE", "DENY"]
        if not value_allowed_none_or_none_sentinel(chosen_option, allowed_values):
            raise ValueError(
                f"Invalid value for `chosen_option`, must be None or one of {allowed_values}"
            )
        self._chosen_option = chosen_option

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
