# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ToolInput(object):
    """
    Base object for tool input parameters. The 'toolInputType' discriminator determines the specific input structure to be used.
    """

    #: A constant which can be used with the tool_input_type property of a ToolInput.
    #: This constant has a value of "GENERIC_TOOL_INPUT"
    TOOL_INPUT_TYPE_GENERIC_TOOL_INPUT = "GENERIC_TOOL_INPUT"

    def __init__(self, **kwargs):
        """
        Initializes a new ToolInput object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.generative_ai_agent_runtime.models.GenericToolInput`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param tool_id:
            The value to assign to the tool_id property of this ToolInput.
        :type tool_id: str

        :param tool_input_type:
            The value to assign to the tool_input_type property of this ToolInput.
            Allowed values for this property are: "GENERIC_TOOL_INPUT"
        :type tool_input_type: str

        """
        self.swagger_types = {
            'tool_id': 'str',
            'tool_input_type': 'str'
        }
        self.attribute_map = {
            'tool_id': 'toolId',
            'tool_input_type': 'toolInputType'
        }
        self._tool_id = None
        self._tool_input_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['toolInputType']

        if type == 'GENERIC_TOOL_INPUT':
            return 'GenericToolInput'
        else:
            return 'ToolInput'

    @property
    def tool_id(self):
        """
        **[Required]** Gets the tool_id of this ToolInput.
        Unique OCID of the tool.


        :return: The tool_id of this ToolInput.
        :rtype: str
        """
        return self._tool_id

    @tool_id.setter
    def tool_id(self, tool_id):
        """
        Sets the tool_id of this ToolInput.
        Unique OCID of the tool.


        :param tool_id: The tool_id of this ToolInput.
        :type: str
        """
        self._tool_id = tool_id

    @property
    def tool_input_type(self):
        """
        **[Required]** Gets the tool_input_type of this ToolInput.
        Specifies the type of tool input (e.g., GENERIC_TOOL_INPUT).

        Allowed values for this property are: "GENERIC_TOOL_INPUT"


        :return: The tool_input_type of this ToolInput.
        :rtype: str
        """
        return self._tool_input_type

    @tool_input_type.setter
    def tool_input_type(self, tool_input_type):
        """
        Sets the tool_input_type of this ToolInput.
        Specifies the type of tool input (e.g., GENERIC_TOOL_INPUT).


        :param tool_input_type: The tool_input_type of this ToolInput.
        :type: str
        """
        allowed_values = ["GENERIC_TOOL_INPUT"]
        if not value_allowed_none_or_none_sentinel(tool_input_type, allowed_values):
            raise ValueError(
                f"Invalid value for `tool_input_type`, must be None or one of {allowed_values}"
            )
        self._tool_input_type = tool_input_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
