# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ContentModerationConfiguration(object):
    """
    Configuration for content moderation.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ContentModerationConfiguration object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param categories:
            The value to assign to the categories property of this ContentModerationConfiguration.
        :type categories: list[str]

        """
        self.swagger_types = {
            'categories': 'list[str]'
        }
        self.attribute_map = {
            'categories': 'categories'
        }
        self._categories = None

    @property
    def categories(self):
        """
        **[Required]** Gets the categories of this ContentModerationConfiguration.
        The categories to detect in the input text.


        :return: The categories of this ContentModerationConfiguration.
        :rtype: list[str]
        """
        return self._categories

    @categories.setter
    def categories(self, categories):
        """
        Sets the categories of this ContentModerationConfiguration.
        The categories to detect in the input text.


        :param categories: The categories of this ContentModerationConfiguration.
        :type: list[str]
        """
        self._categories = categories

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
