# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: v1


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CloudGateExtServers(object):
    """
    A list of Server Blocks on this Cloud Gate
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CloudGateExtServers object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param server_id:
            The value to assign to the server_id property of this CloudGateExtServers.
        :type server_id: str

        :param host_name:
            The value to assign to the host_name property of this CloudGateExtServers.
        :type host_name: str

        :param port:
            The value to assign to the port property of this CloudGateExtServers.
        :type port: int

        :param ssl:
            The value to assign to the ssl property of this CloudGateExtServers.
        :type ssl: bool

        :param nginx_settings:
            The value to assign to the nginx_settings property of this CloudGateExtServers.
        :type nginx_settings: str

        """
        self.swagger_types = {
            'server_id': 'str',
            'host_name': 'str',
            'port': 'int',
            'ssl': 'bool',
            'nginx_settings': 'str'
        }
        self.attribute_map = {
            'server_id': 'serverId',
            'host_name': 'hostName',
            'port': 'port',
            'ssl': 'ssl',
            'nginx_settings': 'nginxSettings'
        }
        self._server_id = None
        self._host_name = None
        self._port = None
        self._ssl = None
        self._nginx_settings = None

    @property
    def server_id(self):
        """
        Gets the server_id of this CloudGateExtServers.
        Server Name for the Server Block

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The server_id of this CloudGateExtServers.
        :rtype: str
        """
        return self._server_id

    @server_id.setter
    def server_id(self, server_id):
        """
        Sets the server_id of this CloudGateExtServers.
        Server Name for the Server Block

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param server_id: The server_id of this CloudGateExtServers.
        :type: str
        """
        self._server_id = server_id

    @property
    def host_name(self):
        """
        **[Required]** Gets the host_name of this CloudGateExtServers.
        Hostname for the Server block

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :return: The host_name of this CloudGateExtServers.
        :rtype: str
        """
        return self._host_name

    @host_name.setter
    def host_name(self, host_name):
        """
        Sets the host_name of this CloudGateExtServers.
        Hostname for the Server block

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :param host_name: The host_name of this CloudGateExtServers.
        :type: str
        """
        self._host_name = host_name

    @property
    def port(self):
        """
        **[Required]** Gets the port of this CloudGateExtServers.
        Port for the Server Block

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: true
         - returned: default
         - type: integer
         - uniqueness: none


        :return: The port of this CloudGateExtServers.
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port):
        """
        Sets the port of this CloudGateExtServers.
        Port for the Server Block

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: true
         - returned: default
         - type: integer
         - uniqueness: none


        :param port: The port of this CloudGateExtServers.
        :type: int
        """
        self._port = port

    @property
    def ssl(self):
        """
        **[Required]** Gets the ssl of this CloudGateExtServers.
        SSL flag for the Server Block

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: true
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The ssl of this CloudGateExtServers.
        :rtype: bool
        """
        return self._ssl

    @ssl.setter
    def ssl(self, ssl):
        """
        Sets the ssl of this CloudGateExtServers.
        SSL flag for the Server Block

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: true
         - returned: default
         - type: boolean
         - uniqueness: none


        :param ssl: The ssl of this CloudGateExtServers.
        :type: bool
        """
        self._ssl = ssl

    @property
    def nginx_settings(self):
        """
        Gets the nginx_settings of this CloudGateExtServers.
        More nginx Settings. JSON encoded text block

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The nginx_settings of this CloudGateExtServers.
        :rtype: str
        """
        return self._nginx_settings

    @nginx_settings.setter
    def nginx_settings(self, nginx_settings):
        """
        Sets the nginx_settings of this CloudGateExtServers.
        More nginx Settings. JSON encoded text block

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param nginx_settings: The nginx_settings of this CloudGateExtServers.
        :type: str
        """
        self._nginx_settings = nginx_settings

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
