# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ChangeIotDomainDataRetentionPeriodDetails(object):
    """
    The configuration details for data retention periods.
    """

    #: A constant which can be used with the type property of a ChangeIotDomainDataRetentionPeriodDetails.
    #: This constant has a value of "RAW_DATA"
    TYPE_RAW_DATA = "RAW_DATA"

    #: A constant which can be used with the type property of a ChangeIotDomainDataRetentionPeriodDetails.
    #: This constant has a value of "REJECTED_DATA"
    TYPE_REJECTED_DATA = "REJECTED_DATA"

    #: A constant which can be used with the type property of a ChangeIotDomainDataRetentionPeriodDetails.
    #: This constant has a value of "HISTORIZED_DATA"
    TYPE_HISTORIZED_DATA = "HISTORIZED_DATA"

    #: A constant which can be used with the type property of a ChangeIotDomainDataRetentionPeriodDetails.
    #: This constant has a value of "RAW_COMMAND_DATA"
    TYPE_RAW_COMMAND_DATA = "RAW_COMMAND_DATA"

    def __init__(self, **kwargs):
        """
        Initializes a new ChangeIotDomainDataRetentionPeriodDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this ChangeIotDomainDataRetentionPeriodDetails.
            Allowed values for this property are: "RAW_DATA", "REJECTED_DATA", "HISTORIZED_DATA", "RAW_COMMAND_DATA"
        :type type: str

        :param data_retention_period_in_days:
            The value to assign to the data_retention_period_in_days property of this ChangeIotDomainDataRetentionPeriodDetails.
        :type data_retention_period_in_days: int

        """
        self.swagger_types = {
            'type': 'str',
            'data_retention_period_in_days': 'int'
        }
        self.attribute_map = {
            'type': 'type',
            'data_retention_period_in_days': 'dataRetentionPeriodInDays'
        }
        self._type = None
        self._data_retention_period_in_days = None

    @property
    def type(self):
        """
        **[Required]** Gets the type of this ChangeIotDomainDataRetentionPeriodDetails.
        The type of data retention period to apply. Allowed values are RAW_DATA, REJECTED_DATA, HISTORIZED_DATA, and RAW_COMMAND_DATA.

        Allowed values for this property are: "RAW_DATA", "REJECTED_DATA", "HISTORIZED_DATA", "RAW_COMMAND_DATA"


        :return: The type of this ChangeIotDomainDataRetentionPeriodDetails.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this ChangeIotDomainDataRetentionPeriodDetails.
        The type of data retention period to apply. Allowed values are RAW_DATA, REJECTED_DATA, HISTORIZED_DATA, and RAW_COMMAND_DATA.


        :param type: The type of this ChangeIotDomainDataRetentionPeriodDetails.
        :type: str
        """
        allowed_values = ["RAW_DATA", "REJECTED_DATA", "HISTORIZED_DATA", "RAW_COMMAND_DATA"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            raise ValueError(
                f"Invalid value for `type`, must be None or one of {allowed_values}"
            )
        self._type = type

    @property
    def data_retention_period_in_days(self):
        """
        **[Required]** Gets the data_retention_period_in_days of this ChangeIotDomainDataRetentionPeriodDetails.
        The duration (in days) for which data will be retained in the IoT domain.


        :return: The data_retention_period_in_days of this ChangeIotDomainDataRetentionPeriodDetails.
        :rtype: int
        """
        return self._data_retention_period_in_days

    @data_retention_period_in_days.setter
    def data_retention_period_in_days(self, data_retention_period_in_days):
        """
        Sets the data_retention_period_in_days of this ChangeIotDomainDataRetentionPeriodDetails.
        The duration (in days) for which data will be retained in the IoT domain.


        :param data_retention_period_in_days: The data_retention_period_in_days of this ChangeIotDomainDataRetentionPeriodDetails.
        :type: int
        """
        self._data_retention_period_in_days = data_retention_period_in_days

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
