# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DigitalTwinInstanceSummary(object):
    """
    Summary of the digital twin instance
    """

    #: A constant which can be used with the lifecycle_state property of a DigitalTwinInstanceSummary.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a DigitalTwinInstanceSummary.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    def __init__(self, **kwargs):
        """
        Initializes a new DigitalTwinInstanceSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this DigitalTwinInstanceSummary.
        :type id: str

        :param iot_domain_id:
            The value to assign to the iot_domain_id property of this DigitalTwinInstanceSummary.
        :type iot_domain_id: str

        :param auth_id:
            The value to assign to the auth_id property of this DigitalTwinInstanceSummary.
        :type auth_id: str

        :param external_key:
            The value to assign to the external_key property of this DigitalTwinInstanceSummary.
        :type external_key: str

        :param display_name:
            The value to assign to the display_name property of this DigitalTwinInstanceSummary.
        :type display_name: str

        :param description:
            The value to assign to the description property of this DigitalTwinInstanceSummary.
        :type description: str

        :param digital_twin_model_id:
            The value to assign to the digital_twin_model_id property of this DigitalTwinInstanceSummary.
        :type digital_twin_model_id: str

        :param digital_twin_model_spec_uri:
            The value to assign to the digital_twin_model_spec_uri property of this DigitalTwinInstanceSummary.
        :type digital_twin_model_spec_uri: str

        :param digital_twin_adapter_id:
            The value to assign to the digital_twin_adapter_id property of this DigitalTwinInstanceSummary.
        :type digital_twin_adapter_id: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this DigitalTwinInstanceSummary.
            Allowed values for this property are: "ACTIVE", "DELETED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this DigitalTwinInstanceSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this DigitalTwinInstanceSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this DigitalTwinInstanceSummary.
        :type system_tags: dict(str, dict(str, object))

        :param time_created:
            The value to assign to the time_created property of this DigitalTwinInstanceSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this DigitalTwinInstanceSummary.
        :type time_updated: datetime

        """
        self.swagger_types = {
            'id': 'str',
            'iot_domain_id': 'str',
            'auth_id': 'str',
            'external_key': 'str',
            'display_name': 'str',
            'description': 'str',
            'digital_twin_model_id': 'str',
            'digital_twin_model_spec_uri': 'str',
            'digital_twin_adapter_id': 'str',
            'lifecycle_state': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))',
            'time_created': 'datetime',
            'time_updated': 'datetime'
        }
        self.attribute_map = {
            'id': 'id',
            'iot_domain_id': 'iotDomainId',
            'auth_id': 'authId',
            'external_key': 'externalKey',
            'display_name': 'displayName',
            'description': 'description',
            'digital_twin_model_id': 'digitalTwinModelId',
            'digital_twin_model_spec_uri': 'digitalTwinModelSpecUri',
            'digital_twin_adapter_id': 'digitalTwinAdapterId',
            'lifecycle_state': 'lifecycleState',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated'
        }
        self._id = None
        self._iot_domain_id = None
        self._auth_id = None
        self._external_key = None
        self._display_name = None
        self._description = None
        self._digital_twin_model_id = None
        self._digital_twin_model_spec_uri = None
        self._digital_twin_adapter_id = None
        self._lifecycle_state = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None
        self._time_created = None
        self._time_updated = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this DigitalTwinInstanceSummary.
        The `OCID`__ of the resource.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this DigitalTwinInstanceSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this DigitalTwinInstanceSummary.
        The `OCID`__ of the resource.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this DigitalTwinInstanceSummary.
        :type: str
        """
        self._id = id

    @property
    def iot_domain_id(self):
        """
        **[Required]** Gets the iot_domain_id of this DigitalTwinInstanceSummary.
        The `OCID`__ of the IoT domain.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The iot_domain_id of this DigitalTwinInstanceSummary.
        :rtype: str
        """
        return self._iot_domain_id

    @iot_domain_id.setter
    def iot_domain_id(self, iot_domain_id):
        """
        Sets the iot_domain_id of this DigitalTwinInstanceSummary.
        The `OCID`__ of the IoT domain.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param iot_domain_id: The iot_domain_id of this DigitalTwinInstanceSummary.
        :type: str
        """
        self._iot_domain_id = iot_domain_id

    @property
    def auth_id(self):
        """
        Gets the auth_id of this DigitalTwinInstanceSummary.
        The `OCID`__ of the resource (like VaultSecret, ClientCertificate etc.,) used to authenticate the digital twin instance.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The auth_id of this DigitalTwinInstanceSummary.
        :rtype: str
        """
        return self._auth_id

    @auth_id.setter
    def auth_id(self, auth_id):
        """
        Sets the auth_id of this DigitalTwinInstanceSummary.
        The `OCID`__ of the resource (like VaultSecret, ClientCertificate etc.,) used to authenticate the digital twin instance.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param auth_id: The auth_id of this DigitalTwinInstanceSummary.
        :type: str
        """
        self._auth_id = auth_id

    @property
    def external_key(self):
        """
        Gets the external_key of this DigitalTwinInstanceSummary.
        A unique identifier for the physical entity (typically an IoT device) represented by the digital twin instance.
        This could be a Bluetooth address, Ethernet MAC address, or serial number, depending on the use case.
        If not provided, the system will automatically generate one.


        :return: The external_key of this DigitalTwinInstanceSummary.
        :rtype: str
        """
        return self._external_key

    @external_key.setter
    def external_key(self, external_key):
        """
        Sets the external_key of this DigitalTwinInstanceSummary.
        A unique identifier for the physical entity (typically an IoT device) represented by the digital twin instance.
        This could be a Bluetooth address, Ethernet MAC address, or serial number, depending on the use case.
        If not provided, the system will automatically generate one.


        :param external_key: The external_key of this DigitalTwinInstanceSummary.
        :type: str
        """
        self._external_key = external_key

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this DigitalTwinInstanceSummary.
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.


        :return: The display_name of this DigitalTwinInstanceSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this DigitalTwinInstanceSummary.
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.


        :param display_name: The display_name of this DigitalTwinInstanceSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this DigitalTwinInstanceSummary.
        A short description of the resource.


        :return: The description of this DigitalTwinInstanceSummary.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this DigitalTwinInstanceSummary.
        A short description of the resource.


        :param description: The description of this DigitalTwinInstanceSummary.
        :type: str
        """
        self._description = description

    @property
    def digital_twin_model_id(self):
        """
        Gets the digital_twin_model_id of this DigitalTwinInstanceSummary.
        The `OCID`__ of the digital twin model.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The digital_twin_model_id of this DigitalTwinInstanceSummary.
        :rtype: str
        """
        return self._digital_twin_model_id

    @digital_twin_model_id.setter
    def digital_twin_model_id(self, digital_twin_model_id):
        """
        Sets the digital_twin_model_id of this DigitalTwinInstanceSummary.
        The `OCID`__ of the digital twin model.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param digital_twin_model_id: The digital_twin_model_id of this DigitalTwinInstanceSummary.
        :type: str
        """
        self._digital_twin_model_id = digital_twin_model_id

    @property
    def digital_twin_model_spec_uri(self):
        """
        Gets the digital_twin_model_spec_uri of this DigitalTwinInstanceSummary.
        The URI of the digital twin model specification.


        :return: The digital_twin_model_spec_uri of this DigitalTwinInstanceSummary.
        :rtype: str
        """
        return self._digital_twin_model_spec_uri

    @digital_twin_model_spec_uri.setter
    def digital_twin_model_spec_uri(self, digital_twin_model_spec_uri):
        """
        Sets the digital_twin_model_spec_uri of this DigitalTwinInstanceSummary.
        The URI of the digital twin model specification.


        :param digital_twin_model_spec_uri: The digital_twin_model_spec_uri of this DigitalTwinInstanceSummary.
        :type: str
        """
        self._digital_twin_model_spec_uri = digital_twin_model_spec_uri

    @property
    def digital_twin_adapter_id(self):
        """
        Gets the digital_twin_adapter_id of this DigitalTwinInstanceSummary.
        The `OCID`__ of the digital twin adapter.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The digital_twin_adapter_id of this DigitalTwinInstanceSummary.
        :rtype: str
        """
        return self._digital_twin_adapter_id

    @digital_twin_adapter_id.setter
    def digital_twin_adapter_id(self, digital_twin_adapter_id):
        """
        Sets the digital_twin_adapter_id of this DigitalTwinInstanceSummary.
        The `OCID`__ of the digital twin adapter.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param digital_twin_adapter_id: The digital_twin_adapter_id of this DigitalTwinInstanceSummary.
        :type: str
        """
        self._digital_twin_adapter_id = digital_twin_adapter_id

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this DigitalTwinInstanceSummary.
        The current state of the digital twin instance.

        Allowed values for this property are: "ACTIVE", "DELETED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this DigitalTwinInstanceSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this DigitalTwinInstanceSummary.
        The current state of the digital twin instance.


        :param lifecycle_state: The lifecycle_state of this DigitalTwinInstanceSummary.
        :type: str
        """
        allowed_values = ["ACTIVE", "DELETED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this DigitalTwinInstanceSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this DigitalTwinInstanceSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this DigitalTwinInstanceSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this DigitalTwinInstanceSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this DigitalTwinInstanceSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this DigitalTwinInstanceSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this DigitalTwinInstanceSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this DigitalTwinInstanceSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this DigitalTwinInstanceSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this DigitalTwinInstanceSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this DigitalTwinInstanceSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this DigitalTwinInstanceSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this DigitalTwinInstanceSummary.
        The date and time when the resource was created, in the format defined by `RFC 3339`__.
        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this DigitalTwinInstanceSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this DigitalTwinInstanceSummary.
        The date and time when the resource was created, in the format defined by `RFC 3339`__.
        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this DigitalTwinInstanceSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this DigitalTwinInstanceSummary.
        The date and time when the resource was last updated, in the format defined by `RFC 3339`__.
        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this DigitalTwinInstanceSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this DigitalTwinInstanceSummary.
        The date and time when the resource was last updated, in the format defined by `RFC 3339`__.
        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this DigitalTwinInstanceSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
