# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240901


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class KafkaClusterConfigVersionSummary(object):
    """
    Summary information about a KafkaClusterConfigVersion.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new KafkaClusterConfigVersionSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param config_id:
            The value to assign to the config_id property of this KafkaClusterConfigVersionSummary.
        :type config_id: str

        :param version_number:
            The value to assign to the version_number property of this KafkaClusterConfigVersionSummary.
        :type version_number: int

        :param time_created:
            The value to assign to the time_created property of this KafkaClusterConfigVersionSummary.
        :type time_created: datetime

        """
        self.swagger_types = {
            'config_id': 'str',
            'version_number': 'int',
            'time_created': 'datetime'
        }
        self.attribute_map = {
            'config_id': 'configId',
            'version_number': 'versionNumber',
            'time_created': 'timeCreated'
        }
        self._config_id = None
        self._version_number = None
        self._time_created = None

    @property
    def config_id(self):
        """
        **[Required]** Gets the config_id of this KafkaClusterConfigVersionSummary.
        The `OCID`__ of the KafkaClusterConfig.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The config_id of this KafkaClusterConfigVersionSummary.
        :rtype: str
        """
        return self._config_id

    @config_id.setter
    def config_id(self, config_id):
        """
        Sets the config_id of this KafkaClusterConfigVersionSummary.
        The `OCID`__ of the KafkaClusterConfig.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param config_id: The config_id of this KafkaClusterConfigVersionSummary.
        :type: str
        """
        self._config_id = config_id

    @property
    def version_number(self):
        """
        **[Required]** Gets the version_number of this KafkaClusterConfigVersionSummary.
        Version of the cluster configuration


        :return: The version_number of this KafkaClusterConfigVersionSummary.
        :rtype: int
        """
        return self._version_number

    @version_number.setter
    def version_number(self, version_number):
        """
        Sets the version_number of this KafkaClusterConfigVersionSummary.
        Version of the cluster configuration


        :param version_number: The version_number of this KafkaClusterConfigVersionSummary.
        :type: int
        """
        self._version_number = version_number

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this KafkaClusterConfigVersionSummary.
        The date and time the KafkaClusterConfigVersion was created, in the format defined by `RFC 3339`__.
        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this KafkaClusterConfigVersionSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this KafkaClusterConfigVersionSummary.
        The date and time the KafkaClusterConfigVersion was created, in the format defined by `RFC 3339`__.
        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this KafkaClusterConfigVersionSummary.
        :type: datetime
        """
        self._time_created = time_created

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
