# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateMachineImageDetails(object):
    """
    Machine image details required to create an Image artifact.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateMachineImageDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param source_image_id:
            The value to assign to the source_image_id property of this CreateMachineImageDetails.
        :type source_image_id: str

        :param username:
            The value to assign to the username property of this CreateMachineImageDetails.
        :type username: str

        :param is_snapshot_allowed:
            The value to assign to the is_snapshot_allowed property of this CreateMachineImageDetails.
        :type is_snapshot_allowed: bool

        :param image_shape_compatibility_entries:
            The value to assign to the image_shape_compatibility_entries property of this CreateMachineImageDetails.
        :type image_shape_compatibility_entries: list[oci.marketplace_publisher.models.ImageShapeCompatibility]

        """
        self.swagger_types = {
            'source_image_id': 'str',
            'username': 'str',
            'is_snapshot_allowed': 'bool',
            'image_shape_compatibility_entries': 'list[ImageShapeCompatibility]'
        }
        self.attribute_map = {
            'source_image_id': 'sourceImageId',
            'username': 'username',
            'is_snapshot_allowed': 'isSnapshotAllowed',
            'image_shape_compatibility_entries': 'imageShapeCompatibilityEntries'
        }
        self._source_image_id = None
        self._username = None
        self._is_snapshot_allowed = None
        self._image_shape_compatibility_entries = None

    @property
    def source_image_id(self):
        """
        **[Required]** Gets the source_image_id of this CreateMachineImageDetails.
        The OCID of source Machine Image.


        :return: The source_image_id of this CreateMachineImageDetails.
        :rtype: str
        """
        return self._source_image_id

    @source_image_id.setter
    def source_image_id(self, source_image_id):
        """
        Sets the source_image_id of this CreateMachineImageDetails.
        The OCID of source Machine Image.


        :param source_image_id: The source_image_id of this CreateMachineImageDetails.
        :type: str
        """
        self._source_image_id = source_image_id

    @property
    def username(self):
        """
        Gets the username of this CreateMachineImageDetails.
        The username for machine image.


        :return: The username of this CreateMachineImageDetails.
        :rtype: str
        """
        return self._username

    @username.setter
    def username(self, username):
        """
        Sets the username of this CreateMachineImageDetails.
        The username for machine image.


        :param username: The username of this CreateMachineImageDetails.
        :type: str
        """
        self._username = username

    @property
    def is_snapshot_allowed(self):
        """
        **[Required]** Gets the is_snapshot_allowed of this CreateMachineImageDetails.
        Indicates if the customer is allowed to take a snapshot of running instance created from the machine image.


        :return: The is_snapshot_allowed of this CreateMachineImageDetails.
        :rtype: bool
        """
        return self._is_snapshot_allowed

    @is_snapshot_allowed.setter
    def is_snapshot_allowed(self, is_snapshot_allowed):
        """
        Sets the is_snapshot_allowed of this CreateMachineImageDetails.
        Indicates if the customer is allowed to take a snapshot of running instance created from the machine image.


        :param is_snapshot_allowed: The is_snapshot_allowed of this CreateMachineImageDetails.
        :type: bool
        """
        self._is_snapshot_allowed = is_snapshot_allowed

    @property
    def image_shape_compatibility_entries(self):
        """
        **[Required]** Gets the image_shape_compatibility_entries of this CreateMachineImageDetails.
        List of shape configurations compatible with the image.


        :return: The image_shape_compatibility_entries of this CreateMachineImageDetails.
        :rtype: list[oci.marketplace_publisher.models.ImageShapeCompatibility]
        """
        return self._image_shape_compatibility_entries

    @image_shape_compatibility_entries.setter
    def image_shape_compatibility_entries(self, image_shape_compatibility_entries):
        """
        Sets the image_shape_compatibility_entries of this CreateMachineImageDetails.
        List of shape configurations compatible with the image.


        :param image_shape_compatibility_entries: The image_shape_compatibility_entries of this CreateMachineImageDetails.
        :type: list[oci.marketplace_publisher.models.ImageShapeCompatibility]
        """
        self._image_shape_compatibility_entries = image_shape_compatibility_entries

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
