# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ListingRevision(object):
    """
    The model for an Oracle Cloud Infrastructure Marketplace Publisher listing revision.
    """

    #: A constant which can be used with the status property of a ListingRevision.
    #: This constant has a value of "NEW"
    STATUS_NEW = "NEW"

    #: A constant which can be used with the status property of a ListingRevision.
    #: This constant has a value of "PENDING_REVIEW"
    STATUS_PENDING_REVIEW = "PENDING_REVIEW"

    #: A constant which can be used with the status property of a ListingRevision.
    #: This constant has a value of "REVIEW_IN_PROGRESS"
    STATUS_REVIEW_IN_PROGRESS = "REVIEW_IN_PROGRESS"

    #: A constant which can be used with the status property of a ListingRevision.
    #: This constant has a value of "REJECTED"
    STATUS_REJECTED = "REJECTED"

    #: A constant which can be used with the status property of a ListingRevision.
    #: This constant has a value of "APPROVED"
    STATUS_APPROVED = "APPROVED"

    #: A constant which can be used with the status property of a ListingRevision.
    #: This constant has a value of "PUBLISH_IN_PROGRESS"
    STATUS_PUBLISH_IN_PROGRESS = "PUBLISH_IN_PROGRESS"

    #: A constant which can be used with the status property of a ListingRevision.
    #: This constant has a value of "PUBLISH_FAILED"
    STATUS_PUBLISH_FAILED = "PUBLISH_FAILED"

    #: A constant which can be used with the status property of a ListingRevision.
    #: This constant has a value of "PUBLISHED"
    STATUS_PUBLISHED = "PUBLISHED"

    #: A constant which can be used with the status property of a ListingRevision.
    #: This constant has a value of "PUBLISH_AS_PRIVATE_FAILED"
    STATUS_PUBLISH_AS_PRIVATE_FAILED = "PUBLISH_AS_PRIVATE_FAILED"

    #: A constant which can be used with the status property of a ListingRevision.
    #: This constant has a value of "PUBLISHED_AS_PRIVATE"
    STATUS_PUBLISHED_AS_PRIVATE = "PUBLISHED_AS_PRIVATE"

    #: A constant which can be used with the status property of a ListingRevision.
    #: This constant has a value of "PUBLISH_AS_PRIVATE_IN_PROGRESS"
    STATUS_PUBLISH_AS_PRIVATE_IN_PROGRESS = "PUBLISH_AS_PRIVATE_IN_PROGRESS"

    #: A constant which can be used with the status property of a ListingRevision.
    #: This constant has a value of "UNPUBLISH_IN_PROGRESS"
    STATUS_UNPUBLISH_IN_PROGRESS = "UNPUBLISH_IN_PROGRESS"

    #: A constant which can be used with the status property of a ListingRevision.
    #: This constant has a value of "UNPUBLISHED"
    STATUS_UNPUBLISHED = "UNPUBLISHED"

    #: A constant which can be used with the lifecycle_state property of a ListingRevision.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a ListingRevision.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a ListingRevision.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a ListingRevision.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a ListingRevision.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a ListingRevision.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the package_type property of a ListingRevision.
    #: This constant has a value of "CONTAINER_IMAGE"
    PACKAGE_TYPE_CONTAINER_IMAGE = "CONTAINER_IMAGE"

    #: A constant which can be used with the package_type property of a ListingRevision.
    #: This constant has a value of "HELM_CHART"
    PACKAGE_TYPE_HELM_CHART = "HELM_CHART"

    #: A constant which can be used with the package_type property of a ListingRevision.
    #: This constant has a value of "MACHINE_IMAGE"
    PACKAGE_TYPE_MACHINE_IMAGE = "MACHINE_IMAGE"

    #: A constant which can be used with the package_type property of a ListingRevision.
    #: This constant has a value of "STACK"
    PACKAGE_TYPE_STACK = "STACK"

    #: A constant which can be used with the package_type property of a ListingRevision.
    #: This constant has a value of "NONE"
    PACKAGE_TYPE_NONE = "NONE"

    #: A constant which can be used with the listing_type property of a ListingRevision.
    #: This constant has a value of "OCI_APPLICATION"
    LISTING_TYPE_OCI_APPLICATION = "OCI_APPLICATION"

    #: A constant which can be used with the listing_type property of a ListingRevision.
    #: This constant has a value of "LEAD_GENERATION"
    LISTING_TYPE_LEAD_GENERATION = "LEAD_GENERATION"

    #: A constant which can be used with the listing_type property of a ListingRevision.
    #: This constant has a value of "SERVICE"
    LISTING_TYPE_SERVICE = "SERVICE"

    def __init__(self, **kwargs):
        """
        Initializes a new ListingRevision object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.marketplace_publisher.models.ServiceListingRevision`
        * :class:`~oci.marketplace_publisher.models.LeadGenListingRevision`
        * :class:`~oci.marketplace_publisher.models.OciListingRevision`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this ListingRevision.
        :type id: str

        :param listing_id:
            The value to assign to the listing_id property of this ListingRevision.
        :type listing_id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this ListingRevision.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this ListingRevision.
        :type display_name: str

        :param revision_number:
            The value to assign to the revision_number property of this ListingRevision.
        :type revision_number: str

        :param headline:
            The value to assign to the headline property of this ListingRevision.
        :type headline: str

        :param tagline:
            The value to assign to the tagline property of this ListingRevision.
        :type tagline: str

        :param keywords:
            The value to assign to the keywords property of this ListingRevision.
        :type keywords: str

        :param short_description:
            The value to assign to the short_description property of this ListingRevision.
        :type short_description: str

        :param usage_information:
            The value to assign to the usage_information property of this ListingRevision.
        :type usage_information: str

        :param long_description:
            The value to assign to the long_description property of this ListingRevision.
        :type long_description: str

        :param time_created:
            The value to assign to the time_created property of this ListingRevision.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this ListingRevision.
        :type time_updated: datetime

        :param content_language:
            The value to assign to the content_language property of this ListingRevision.
        :type content_language: oci.marketplace_publisher.models.LanguageItem

        :param supportedlanguages:
            The value to assign to the supportedlanguages property of this ListingRevision.
        :type supportedlanguages: list[oci.marketplace_publisher.models.LanguageItem]

        :param support_contacts:
            The value to assign to the support_contacts property of this ListingRevision.
        :type support_contacts: list[oci.marketplace_publisher.models.SupportContact]

        :param support_links:
            The value to assign to the support_links property of this ListingRevision.
        :type support_links: list[oci.marketplace_publisher.models.NamedLink]

        :param icon:
            The value to assign to the icon property of this ListingRevision.
        :type icon: oci.marketplace_publisher.models.ListingRevisionIconAttachment

        :param status:
            The value to assign to the status property of this ListingRevision.
            Allowed values for this property are: "NEW", "PENDING_REVIEW", "REVIEW_IN_PROGRESS", "REJECTED", "APPROVED", "PUBLISH_IN_PROGRESS", "PUBLISH_FAILED", "PUBLISHED", "PUBLISH_AS_PRIVATE_FAILED", "PUBLISHED_AS_PRIVATE", "PUBLISH_AS_PRIVATE_IN_PROGRESS", "UNPUBLISH_IN_PROGRESS", "UNPUBLISHED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type status: str

        :param status_notes:
            The value to assign to the status_notes property of this ListingRevision.
        :type status_notes: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this ListingRevision.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param package_type:
            The value to assign to the package_type property of this ListingRevision.
            Allowed values for this property are: "CONTAINER_IMAGE", "HELM_CHART", "MACHINE_IMAGE", "STACK", "NONE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type package_type: str

        :param listing_type:
            The value to assign to the listing_type property of this ListingRevision.
            Allowed values for this property are: "OCI_APPLICATION", "LEAD_GENERATION", "SERVICE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type listing_type: str

        :param extended_metadata:
            The value to assign to the extended_metadata property of this ListingRevision.
        :type extended_metadata: dict(str, str)

        :param freeform_tags:
            The value to assign to the freeform_tags property of this ListingRevision.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this ListingRevision.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this ListingRevision.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'listing_id': 'str',
            'compartment_id': 'str',
            'display_name': 'str',
            'revision_number': 'str',
            'headline': 'str',
            'tagline': 'str',
            'keywords': 'str',
            'short_description': 'str',
            'usage_information': 'str',
            'long_description': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'content_language': 'LanguageItem',
            'supportedlanguages': 'list[LanguageItem]',
            'support_contacts': 'list[SupportContact]',
            'support_links': 'list[NamedLink]',
            'icon': 'ListingRevisionIconAttachment',
            'status': 'str',
            'status_notes': 'str',
            'lifecycle_state': 'str',
            'package_type': 'str',
            'listing_type': 'str',
            'extended_metadata': 'dict(str, str)',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'listing_id': 'listingId',
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'revision_number': 'revisionNumber',
            'headline': 'headline',
            'tagline': 'tagline',
            'keywords': 'keywords',
            'short_description': 'shortDescription',
            'usage_information': 'usageInformation',
            'long_description': 'longDescription',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'content_language': 'contentLanguage',
            'supportedlanguages': 'supportedlanguages',
            'support_contacts': 'supportContacts',
            'support_links': 'supportLinks',
            'icon': 'icon',
            'status': 'status',
            'status_notes': 'statusNotes',
            'lifecycle_state': 'lifecycleState',
            'package_type': 'packageType',
            'listing_type': 'listingType',
            'extended_metadata': 'extendedMetadata',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._listing_id = None
        self._compartment_id = None
        self._display_name = None
        self._revision_number = None
        self._headline = None
        self._tagline = None
        self._keywords = None
        self._short_description = None
        self._usage_information = None
        self._long_description = None
        self._time_created = None
        self._time_updated = None
        self._content_language = None
        self._supportedlanguages = None
        self._support_contacts = None
        self._support_links = None
        self._icon = None
        self._status = None
        self._status_notes = None
        self._lifecycle_state = None
        self._package_type = None
        self._listing_type = None
        self._extended_metadata = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['listingType']

        if type == 'SERVICE':
            return 'ServiceListingRevision'

        if type == 'LEAD_GENERATION':
            return 'LeadGenListingRevision'

        if type == 'OCI_APPLICATION':
            return 'OciListingRevision'
        else:
            return 'ListingRevision'

    @property
    def id(self):
        """
        **[Required]** Gets the id of this ListingRevision.
        Unique OCID identifier for the listing revision in Marketplace Publisher.


        :return: The id of this ListingRevision.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ListingRevision.
        Unique OCID identifier for the listing revision in Marketplace Publisher.


        :param id: The id of this ListingRevision.
        :type: str
        """
        self._id = id

    @property
    def listing_id(self):
        """
        **[Required]** Gets the listing_id of this ListingRevision.
        The unique identifier for the listing this revision belongs to.


        :return: The listing_id of this ListingRevision.
        :rtype: str
        """
        return self._listing_id

    @listing_id.setter
    def listing_id(self, listing_id):
        """
        Sets the listing_id of this ListingRevision.
        The unique identifier for the listing this revision belongs to.


        :param listing_id: The listing_id of this ListingRevision.
        :type: str
        """
        self._listing_id = listing_id

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this ListingRevision.
        The unique identifier for the compartment.


        :return: The compartment_id of this ListingRevision.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this ListingRevision.
        The unique identifier for the compartment.


        :param compartment_id: The compartment_id of this ListingRevision.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this ListingRevision.
        The name for the listing revision.


        :return: The display_name of this ListingRevision.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this ListingRevision.
        The name for the listing revision.


        :param display_name: The display_name of this ListingRevision.
        :type: str
        """
        self._display_name = display_name

    @property
    def revision_number(self):
        """
        Gets the revision_number of this ListingRevision.
        The revision number for the listing revision. This is an internal attribute


        :return: The revision_number of this ListingRevision.
        :rtype: str
        """
        return self._revision_number

    @revision_number.setter
    def revision_number(self, revision_number):
        """
        Sets the revision_number of this ListingRevision.
        The revision number for the listing revision. This is an internal attribute


        :param revision_number: The revision_number of this ListingRevision.
        :type: str
        """
        self._revision_number = revision_number

    @property
    def headline(self):
        """
        **[Required]** Gets the headline of this ListingRevision.
        Single line introduction for the listing revision.


        :return: The headline of this ListingRevision.
        :rtype: str
        """
        return self._headline

    @headline.setter
    def headline(self, headline):
        """
        Sets the headline of this ListingRevision.
        Single line introduction for the listing revision.


        :param headline: The headline of this ListingRevision.
        :type: str
        """
        self._headline = headline

    @property
    def tagline(self):
        """
        Gets the tagline of this ListingRevision.
        The tagline of the listing revision.


        :return: The tagline of this ListingRevision.
        :rtype: str
        """
        return self._tagline

    @tagline.setter
    def tagline(self, tagline):
        """
        Sets the tagline of this ListingRevision.
        The tagline of the listing revision.


        :param tagline: The tagline of this ListingRevision.
        :type: str
        """
        self._tagline = tagline

    @property
    def keywords(self):
        """
        Gets the keywords of this ListingRevision.
        Keywords associated with the listing revision.


        :return: The keywords of this ListingRevision.
        :rtype: str
        """
        return self._keywords

    @keywords.setter
    def keywords(self, keywords):
        """
        Sets the keywords of this ListingRevision.
        Keywords associated with the listing revision.


        :param keywords: The keywords of this ListingRevision.
        :type: str
        """
        self._keywords = keywords

    @property
    def short_description(self):
        """
        Gets the short_description of this ListingRevision.
        A short description for the listing revision.


        :return: The short_description of this ListingRevision.
        :rtype: str
        """
        return self._short_description

    @short_description.setter
    def short_description(self, short_description):
        """
        Sets the short_description of this ListingRevision.
        A short description for the listing revision.


        :param short_description: The short_description of this ListingRevision.
        :type: str
        """
        self._short_description = short_description

    @property
    def usage_information(self):
        """
        Gets the usage_information of this ListingRevision.
        Usage information for the listing revision.


        :return: The usage_information of this ListingRevision.
        :rtype: str
        """
        return self._usage_information

    @usage_information.setter
    def usage_information(self, usage_information):
        """
        Sets the usage_information of this ListingRevision.
        Usage information for the listing revision.


        :param usage_information: The usage_information of this ListingRevision.
        :type: str
        """
        self._usage_information = usage_information

    @property
    def long_description(self):
        """
        Gets the long_description of this ListingRevision.
        A long description for the listing revision.


        :return: The long_description of this ListingRevision.
        :rtype: str
        """
        return self._long_description

    @long_description.setter
    def long_description(self, long_description):
        """
        Sets the long_description of this ListingRevision.
        A long description for the listing revision.


        :param long_description: The long_description of this ListingRevision.
        :type: str
        """
        self._long_description = long_description

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this ListingRevision.
        The time the listing revision was created. An RFC3339 formatted datetime string.


        :return: The time_created of this ListingRevision.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this ListingRevision.
        The time the listing revision was created. An RFC3339 formatted datetime string.


        :param time_created: The time_created of this ListingRevision.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this ListingRevision.
        The time the listing revision was updated. An RFC3339 formatted datetime string.


        :return: The time_updated of this ListingRevision.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this ListingRevision.
        The time the listing revision was updated. An RFC3339 formatted datetime string.


        :param time_updated: The time_updated of this ListingRevision.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def content_language(self):
        """
        Gets the content_language of this ListingRevision.

        :return: The content_language of this ListingRevision.
        :rtype: oci.marketplace_publisher.models.LanguageItem
        """
        return self._content_language

    @content_language.setter
    def content_language(self, content_language):
        """
        Sets the content_language of this ListingRevision.

        :param content_language: The content_language of this ListingRevision.
        :type: oci.marketplace_publisher.models.LanguageItem
        """
        self._content_language = content_language

    @property
    def supportedlanguages(self):
        """
        Gets the supportedlanguages of this ListingRevision.
        Languages supported by the publisher for the listing revision.


        :return: The supportedlanguages of this ListingRevision.
        :rtype: list[oci.marketplace_publisher.models.LanguageItem]
        """
        return self._supportedlanguages

    @supportedlanguages.setter
    def supportedlanguages(self, supportedlanguages):
        """
        Sets the supportedlanguages of this ListingRevision.
        Languages supported by the publisher for the listing revision.


        :param supportedlanguages: The supportedlanguages of this ListingRevision.
        :type: list[oci.marketplace_publisher.models.LanguageItem]
        """
        self._supportedlanguages = supportedlanguages

    @property
    def support_contacts(self):
        """
        Gets the support_contacts of this ListingRevision.
        Contact information to use to get support from the publisher for the listing revision.


        :return: The support_contacts of this ListingRevision.
        :rtype: list[oci.marketplace_publisher.models.SupportContact]
        """
        return self._support_contacts

    @support_contacts.setter
    def support_contacts(self, support_contacts):
        """
        Sets the support_contacts of this ListingRevision.
        Contact information to use to get support from the publisher for the listing revision.


        :param support_contacts: The support_contacts of this ListingRevision.
        :type: list[oci.marketplace_publisher.models.SupportContact]
        """
        self._support_contacts = support_contacts

    @property
    def support_links(self):
        """
        Gets the support_links of this ListingRevision.
        Links to support resources for the listing revision.


        :return: The support_links of this ListingRevision.
        :rtype: list[oci.marketplace_publisher.models.NamedLink]
        """
        return self._support_links

    @support_links.setter
    def support_links(self, support_links):
        """
        Sets the support_links of this ListingRevision.
        Links to support resources for the listing revision.


        :param support_links: The support_links of this ListingRevision.
        :type: list[oci.marketplace_publisher.models.NamedLink]
        """
        self._support_links = support_links

    @property
    def icon(self):
        """
        Gets the icon of this ListingRevision.

        :return: The icon of this ListingRevision.
        :rtype: oci.marketplace_publisher.models.ListingRevisionIconAttachment
        """
        return self._icon

    @icon.setter
    def icon(self, icon):
        """
        Sets the icon of this ListingRevision.

        :param icon: The icon of this ListingRevision.
        :type: oci.marketplace_publisher.models.ListingRevisionIconAttachment
        """
        self._icon = icon

    @property
    def status(self):
        """
        **[Required]** Gets the status of this ListingRevision.
        The current status for the Listing revision.

        Allowed values for this property are: "NEW", "PENDING_REVIEW", "REVIEW_IN_PROGRESS", "REJECTED", "APPROVED", "PUBLISH_IN_PROGRESS", "PUBLISH_FAILED", "PUBLISHED", "PUBLISH_AS_PRIVATE_FAILED", "PUBLISHED_AS_PRIVATE", "PUBLISH_AS_PRIVATE_IN_PROGRESS", "UNPUBLISH_IN_PROGRESS", "UNPUBLISHED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The status of this ListingRevision.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this ListingRevision.
        The current status for the Listing revision.


        :param status: The status of this ListingRevision.
        :type: str
        """
        allowed_values = ["NEW", "PENDING_REVIEW", "REVIEW_IN_PROGRESS", "REJECTED", "APPROVED", "PUBLISH_IN_PROGRESS", "PUBLISH_FAILED", "PUBLISHED", "PUBLISH_AS_PRIVATE_FAILED", "PUBLISHED_AS_PRIVATE", "PUBLISH_AS_PRIVATE_IN_PROGRESS", "UNPUBLISH_IN_PROGRESS", "UNPUBLISHED"]
        if not value_allowed_none_or_none_sentinel(status, allowed_values):
            status = 'UNKNOWN_ENUM_VALUE'
        self._status = status

    @property
    def status_notes(self):
        """
        Gets the status_notes of this ListingRevision.
        Status notes for the listing revision.


        :return: The status_notes of this ListingRevision.
        :rtype: str
        """
        return self._status_notes

    @status_notes.setter
    def status_notes(self, status_notes):
        """
        Sets the status_notes of this ListingRevision.
        Status notes for the listing revision.


        :param status_notes: The status_notes of this ListingRevision.
        :type: str
        """
        self._status_notes = status_notes

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this ListingRevision.
        The current state of the listing revision.

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this ListingRevision.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this ListingRevision.
        The current state of the listing revision.


        :param lifecycle_state: The lifecycle_state of this ListingRevision.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def package_type(self):
        """
        Gets the package_type of this ListingRevision.
        The listing's package type. Populated from the listing.

        Allowed values for this property are: "CONTAINER_IMAGE", "HELM_CHART", "MACHINE_IMAGE", "STACK", "NONE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The package_type of this ListingRevision.
        :rtype: str
        """
        return self._package_type

    @package_type.setter
    def package_type(self, package_type):
        """
        Sets the package_type of this ListingRevision.
        The listing's package type. Populated from the listing.


        :param package_type: The package_type of this ListingRevision.
        :type: str
        """
        allowed_values = ["CONTAINER_IMAGE", "HELM_CHART", "MACHINE_IMAGE", "STACK", "NONE"]
        if not value_allowed_none_or_none_sentinel(package_type, allowed_values):
            package_type = 'UNKNOWN_ENUM_VALUE'
        self._package_type = package_type

    @property
    def listing_type(self):
        """
        **[Required]** Gets the listing_type of this ListingRevision.
        The listing's type. Populated from the listing.

        Allowed values for this property are: "OCI_APPLICATION", "LEAD_GENERATION", "SERVICE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The listing_type of this ListingRevision.
        :rtype: str
        """
        return self._listing_type

    @listing_type.setter
    def listing_type(self, listing_type):
        """
        Sets the listing_type of this ListingRevision.
        The listing's type. Populated from the listing.


        :param listing_type: The listing_type of this ListingRevision.
        :type: str
        """
        allowed_values = ["OCI_APPLICATION", "LEAD_GENERATION", "SERVICE"]
        if not value_allowed_none_or_none_sentinel(listing_type, allowed_values):
            listing_type = 'UNKNOWN_ENUM_VALUE'
        self._listing_type = listing_type

    @property
    def extended_metadata(self):
        """
        Gets the extended_metadata of this ListingRevision.
        Additional metadata key/value pairs for the listing revision summary.


        :return: The extended_metadata of this ListingRevision.
        :rtype: dict(str, str)
        """
        return self._extended_metadata

    @extended_metadata.setter
    def extended_metadata(self, extended_metadata):
        """
        Sets the extended_metadata of this ListingRevision.
        Additional metadata key/value pairs for the listing revision summary.


        :param extended_metadata: The extended_metadata of this ListingRevision.
        :type: dict(str, str)
        """
        self._extended_metadata = extended_metadata

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this ListingRevision.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this ListingRevision.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this ListingRevision.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this ListingRevision.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this ListingRevision.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this ListingRevision.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this ListingRevision.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this ListingRevision.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this ListingRevision.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this ListingRevision.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this ListingRevision.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this ListingRevision.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
