# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250320


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateMacOrderDetails(object):
    """
    The data to create a new MacOrder.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateMacOrderDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateMacOrderDetails.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this CreateMacOrderDetails.
        :type display_name: str

        :param order_description:
            The value to assign to the order_description property of this CreateMacOrderDetails.
        :type order_description: str

        :param order_size:
            The value to assign to the order_size property of this CreateMacOrderDetails.
        :type order_size: int

        :param ip_range:
            The value to assign to the ip_range property of this CreateMacOrderDetails.
        :type ip_range: str

        :param shape:
            The value to assign to the shape property of this CreateMacOrderDetails.
        :type shape: str

        :param commitment_term:
            The value to assign to the commitment_term property of this CreateMacOrderDetails.
        :type commitment_term: str

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'display_name': 'str',
            'order_description': 'str',
            'order_size': 'int',
            'ip_range': 'str',
            'shape': 'str',
            'commitment_term': 'str'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'order_description': 'orderDescription',
            'order_size': 'orderSize',
            'ip_range': 'ipRange',
            'shape': 'shape',
            'commitment_term': 'commitmentTerm'
        }
        self._compartment_id = None
        self._display_name = None
        self._order_description = None
        self._order_size = None
        self._ip_range = None
        self._shape = None
        self._commitment_term = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateMacOrderDetails.
        OCID of the compartment to which the resource belongs to.


        :return: The compartment_id of this CreateMacOrderDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateMacOrderDetails.
        OCID of the compartment to which the resource belongs to.


        :param compartment_id: The compartment_id of this CreateMacOrderDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateMacOrderDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :return: The display_name of this CreateMacOrderDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateMacOrderDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.

        Example: `My new resource`


        :param display_name: The display_name of this CreateMacOrderDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def order_description(self):
        """
        **[Required]** Gets the order_description of this CreateMacOrderDetails.
        A user-friendly description. To provide some insight about the resource.
        Avoid entering confidential information.


        :return: The order_description of this CreateMacOrderDetails.
        :rtype: str
        """
        return self._order_description

    @order_description.setter
    def order_description(self, order_description):
        """
        Sets the order_description of this CreateMacOrderDetails.
        A user-friendly description. To provide some insight about the resource.
        Avoid entering confidential information.


        :param order_description: The order_description of this CreateMacOrderDetails.
        :type: str
        """
        self._order_description = order_description

    @property
    def order_size(self):
        """
        **[Required]** Gets the order_size of this CreateMacOrderDetails.
        Number of macs requested in this MacOrder.


        :return: The order_size of this CreateMacOrderDetails.
        :rtype: int
        """
        return self._order_size

    @order_size.setter
    def order_size(self, order_size):
        """
        Sets the order_size of this CreateMacOrderDetails.
        Number of macs requested in this MacOrder.


        :param order_size: The order_size of this CreateMacOrderDetails.
        :type: int
        """
        self._order_size = order_size

    @property
    def ip_range(self):
        """
        Gets the ip_range of this CreateMacOrderDetails.
        The IP Range specified by the customer for this order.


        :return: The ip_range of this CreateMacOrderDetails.
        :rtype: str
        """
        return self._ip_range

    @ip_range.setter
    def ip_range(self, ip_range):
        """
        Sets the ip_range of this CreateMacOrderDetails.
        The IP Range specified by the customer for this order.


        :param ip_range: The ip_range of this CreateMacOrderDetails.
        :type: str
        """
        self._ip_range = ip_range

    @property
    def shape(self):
        """
        **[Required]** Gets the shape of this CreateMacOrderDetails.
        The requested shape of the MacDevices in the MacOrder.


        :return: The shape of this CreateMacOrderDetails.
        :rtype: str
        """
        return self._shape

    @shape.setter
    def shape(self, shape):
        """
        Sets the shape of this CreateMacOrderDetails.
        The requested shape of the MacDevices in the MacOrder.


        :param shape: The shape of this CreateMacOrderDetails.
        :type: str
        """
        self._shape = shape

    @property
    def commitment_term(self):
        """
        **[Required]** Gets the commitment_term of this CreateMacOrderDetails.
        Enum that indicates the agreed commitment term for the MacDevices.


        :return: The commitment_term of this CreateMacOrderDetails.
        :rtype: str
        """
        return self._commitment_term

    @commitment_term.setter
    def commitment_term(self, commitment_term):
        """
        Sets the commitment_term of this CreateMacOrderDetails.
        Enum that indicates the agreed commitment term for the MacDevices.


        :param commitment_term: The commitment_term of this CreateMacOrderDetails.
        :type: str
        """
        self._commitment_term = commitment_term

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
