# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190415


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DataStorageDetails(object):
    """
    Data Storage configuration properties.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DataStorageDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param is_auto_expand_storage_enabled:
            The value to assign to the is_auto_expand_storage_enabled property of this DataStorageDetails.
        :type is_auto_expand_storage_enabled: bool

        :param max_storage_size_in_gbs:
            The value to assign to the max_storage_size_in_gbs property of this DataStorageDetails.
        :type max_storage_size_in_gbs: int

        """
        self.swagger_types = {
            'is_auto_expand_storage_enabled': 'bool',
            'max_storage_size_in_gbs': 'int'
        }
        self.attribute_map = {
            'is_auto_expand_storage_enabled': 'isAutoExpandStorageEnabled',
            'max_storage_size_in_gbs': 'maxStorageSizeInGBs'
        }
        self._is_auto_expand_storage_enabled = None
        self._max_storage_size_in_gbs = None

    @property
    def is_auto_expand_storage_enabled(self):
        """
        Gets the is_auto_expand_storage_enabled of this DataStorageDetails.
        Enable/disable automatic storage expansion. When set to true, the DB System will automatically
        add storage incrementally up to the value specified in maxStorageSizeInGBs.


        :return: The is_auto_expand_storage_enabled of this DataStorageDetails.
        :rtype: bool
        """
        return self._is_auto_expand_storage_enabled

    @is_auto_expand_storage_enabled.setter
    def is_auto_expand_storage_enabled(self, is_auto_expand_storage_enabled):
        """
        Sets the is_auto_expand_storage_enabled of this DataStorageDetails.
        Enable/disable automatic storage expansion. When set to true, the DB System will automatically
        add storage incrementally up to the value specified in maxStorageSizeInGBs.


        :param is_auto_expand_storage_enabled: The is_auto_expand_storage_enabled of this DataStorageDetails.
        :type: bool
        """
        self._is_auto_expand_storage_enabled = is_auto_expand_storage_enabled

    @property
    def max_storage_size_in_gbs(self):
        """
        Gets the max_storage_size_in_gbs of this DataStorageDetails.
        Maximum storage size this DB System can expand to. When isAutoExpandStorageEnabled
        is set to true, the DB System will add storage incrementally up to this value.

        DB Systems with an initial storage size of 400 GB or less can be expanded up to 32 TB.
        DB Systems with an initial storage size between 401-800 GB can be expanded up to 64 TB.
        DB Systems with an initial storage size between 801-1200 GB can be expanded up to 96 TB.
        DB Systems with an initial storage size of 1201 GB or more can be expanded up to 128 TB.

        It is not possible to decrease data storage size. You cannot set the maximum data storage size to less
        than either current DB System dataStorageSizeInGBs or allocatedStorageSizeInGBs.


        :return: The max_storage_size_in_gbs of this DataStorageDetails.
        :rtype: int
        """
        return self._max_storage_size_in_gbs

    @max_storage_size_in_gbs.setter
    def max_storage_size_in_gbs(self, max_storage_size_in_gbs):
        """
        Sets the max_storage_size_in_gbs of this DataStorageDetails.
        Maximum storage size this DB System can expand to. When isAutoExpandStorageEnabled
        is set to true, the DB System will add storage incrementally up to this value.

        DB Systems with an initial storage size of 400 GB or less can be expanded up to 32 TB.
        DB Systems with an initial storage size between 401-800 GB can be expanded up to 64 TB.
        DB Systems with an initial storage size between 801-1200 GB can be expanded up to 96 TB.
        DB Systems with an initial storage size of 1201 GB or more can be expanded up to 128 TB.

        It is not possible to decrease data storage size. You cannot set the maximum data storage size to less
        than either current DB System dataStorageSizeInGBs or allocatedStorageSizeInGBs.


        :param max_storage_size_in_gbs: The max_storage_size_in_gbs of this DataStorageDetails.
        :type: int
        """
        self._max_storage_size_in_gbs = max_storage_size_in_gbs

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
