# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class FailedObjectResult(object):
    """
    Failed object details.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new FailedObjectResult object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param object_name:
            The value to assign to the object_name property of this FailedObjectResult.
        :type object_name: str

        :param status_code:
            The value to assign to the status_code property of this FailedObjectResult.
        :type status_code: int

        :param error_message:
            The value to assign to the error_message property of this FailedObjectResult.
        :type error_message: str

        """
        self.swagger_types = {
            'object_name': 'str',
            'status_code': 'int',
            'error_message': 'str'
        }
        self.attribute_map = {
            'object_name': 'objectName',
            'status_code': 'statusCode',
            'error_message': 'errorMessage'
        }
        self._object_name = None
        self._status_code = None
        self._error_message = None

    @property
    def object_name(self):
        """
        **[Required]** Gets the object_name of this FailedObjectResult.
        The name of the object.
        Example: test/object1.log


        :return: The object_name of this FailedObjectResult.
        :rtype: str
        """
        return self._object_name

    @object_name.setter
    def object_name(self, object_name):
        """
        Sets the object_name of this FailedObjectResult.
        The name of the object.
        Example: test/object1.log


        :param object_name: The object_name of this FailedObjectResult.
        :type: str
        """
        self._object_name = object_name

    @property
    def status_code(self):
        """
        **[Required]** Gets the status_code of this FailedObjectResult.
        HTTP status code for the failure.
        Example: 409


        :return: The status_code of this FailedObjectResult.
        :rtype: int
        """
        return self._status_code

    @status_code.setter
    def status_code(self, status_code):
        """
        Sets the status_code of this FailedObjectResult.
        HTTP status code for the failure.
        Example: 409


        :param status_code: The status_code of this FailedObjectResult.
        :type: int
        """
        self._status_code = status_code

    @property
    def error_message(self):
        """
        **[Required]** Gets the error_message of this FailedObjectResult.
        Detailed error message on why the delete/update was failed.


        :return: The error_message of this FailedObjectResult.
        :rtype: str
        """
        return self._error_message

    @error_message.setter
    def error_message(self, error_message):
        """
        Sets the error_message of this FailedObjectResult.
        Detailed error message on why the delete/update was failed.


        :param error_message: The error_message of this FailedObjectResult.
        :type: str
        """
        self._error_message = error_message

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
