# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180828


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateMaintenanceDetails(object):
    """
    Details for creation of maintenance details
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateMaintenanceDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param notification_email_ids:
            The value to assign to the notification_email_ids property of this CreateMaintenanceDetails.
        :type notification_email_ids: list[str]

        """
        self.swagger_types = {
            'notification_email_ids': 'list[str]'
        }
        self.attribute_map = {
            'notification_email_ids': 'notificationEmailIds'
        }
        self._notification_email_ids = None

    @property
    def notification_email_ids(self):
        """
        Gets the notification_email_ids of this CreateMaintenanceDetails.
        The Email IDs given by the customer to get notified about maintenance activities


        :return: The notification_email_ids of this CreateMaintenanceDetails.
        :rtype: list[str]
        """
        return self._notification_email_ids

    @notification_email_ids.setter
    def notification_email_ids(self, notification_email_ids):
        """
        Sets the notification_email_ids of this CreateMaintenanceDetails.
        The Email IDs given by the customer to get notified about maintenance activities


        :param notification_email_ids: The notification_email_ids of this CreateMaintenanceDetails.
        :type: list[str]
        """
        self._notification_email_ids = notification_email_ids

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
