# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630

from .database_configuration_metric_group import DatabaseConfigurationMetricGroup
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DBConnectionStatus(DatabaseConfigurationMetricGroup):
    """
    Database connection status.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DBConnectionStatus object with values from keyword arguments. The default value of the :py:attr:`~oci.opsi.models.DBConnectionStatus.metric_name` attribute
        of this class is ``DB_CONNECTION_STATUS`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param metric_name:
            The value to assign to the metric_name property of this DBConnectionStatus.
            Allowed values for this property are: "DB_EXTERNAL_PROPERTIES", "DB_EXTERNAL_INSTANCE", "DB_OS_CONFIG_INSTANCE", "DB_PARAMETERS", "DB_CONNECTION_STATUS", "HOST_RESOURCE_ALLOCATION", "ASM_ENTITY", "EXADATA_CELL_CONFIG"
        :type metric_name: str

        :param time_collected:
            The value to assign to the time_collected property of this DBConnectionStatus.
        :type time_collected: datetime

        """
        self.swagger_types = {
            'metric_name': 'str',
            'time_collected': 'datetime'
        }
        self.attribute_map = {
            'metric_name': 'metricName',
            'time_collected': 'timeCollected'
        }
        self._metric_name = None
        self._time_collected = None
        self._metric_name = 'DB_CONNECTION_STATUS'

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
