# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630

from .database_configuration_summary import DatabaseConfigurationSummary
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ExternalMysqlDatabaseConfigurationSummary(DatabaseConfigurationSummary):
    """
    Configuration Summary of a External MySQL database.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ExternalMysqlDatabaseConfigurationSummary object with values from keyword arguments. The default value of the :py:attr:`~oci.opsi.models.ExternalMysqlDatabaseConfigurationSummary.entity_source` attribute
        of this class is ``EXTERNAL_MYSQL_DATABASE_SYSTEM`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param database_insight_id:
            The value to assign to the database_insight_id property of this ExternalMysqlDatabaseConfigurationSummary.
        :type database_insight_id: str

        :param entity_source:
            The value to assign to the entity_source property of this ExternalMysqlDatabaseConfigurationSummary.
            Allowed values for this property are: "AUTONOMOUS_DATABASE", "EM_MANAGED_EXTERNAL_DATABASE", "MACS_MANAGED_EXTERNAL_DATABASE", "PE_COMANAGED_DATABASE", "MDS_MYSQL_DATABASE_SYSTEM", "EXTERNAL_MYSQL_DATABASE_SYSTEM", "MACS_MANAGED_CLOUD_DATABASE", "MACS_MANAGED_AUTONOMOUS_DATABASE"
        :type entity_source: str

        :param compartment_id:
            The value to assign to the compartment_id property of this ExternalMysqlDatabaseConfigurationSummary.
        :type compartment_id: str

        :param database_name:
            The value to assign to the database_name property of this ExternalMysqlDatabaseConfigurationSummary.
        :type database_name: str

        :param database_display_name:
            The value to assign to the database_display_name property of this ExternalMysqlDatabaseConfigurationSummary.
        :type database_display_name: str

        :param database_type:
            The value to assign to the database_type property of this ExternalMysqlDatabaseConfigurationSummary.
        :type database_type: str

        :param database_version:
            The value to assign to the database_version property of this ExternalMysqlDatabaseConfigurationSummary.
        :type database_version: str

        :param cdb_name:
            The value to assign to the cdb_name property of this ExternalMysqlDatabaseConfigurationSummary.
        :type cdb_name: str

        :param defined_tags:
            The value to assign to the defined_tags property of this ExternalMysqlDatabaseConfigurationSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param freeform_tags:
            The value to assign to the freeform_tags property of this ExternalMysqlDatabaseConfigurationSummary.
        :type freeform_tags: dict(str, str)

        :param processor_count:
            The value to assign to the processor_count property of this ExternalMysqlDatabaseConfigurationSummary.
        :type processor_count: int

        :param database_id:
            The value to assign to the database_id property of this ExternalMysqlDatabaseConfigurationSummary.
        :type database_id: str

        :param agent_id:
            The value to assign to the agent_id property of this ExternalMysqlDatabaseConfigurationSummary.
        :type agent_id: str

        :param database_connector_id:
            The value to assign to the database_connector_id property of this ExternalMysqlDatabaseConfigurationSummary.
        :type database_connector_id: str

        """
        self.swagger_types = {
            'database_insight_id': 'str',
            'entity_source': 'str',
            'compartment_id': 'str',
            'database_name': 'str',
            'database_display_name': 'str',
            'database_type': 'str',
            'database_version': 'str',
            'cdb_name': 'str',
            'defined_tags': 'dict(str, dict(str, object))',
            'freeform_tags': 'dict(str, str)',
            'processor_count': 'int',
            'database_id': 'str',
            'agent_id': 'str',
            'database_connector_id': 'str'
        }
        self.attribute_map = {
            'database_insight_id': 'databaseInsightId',
            'entity_source': 'entitySource',
            'compartment_id': 'compartmentId',
            'database_name': 'databaseName',
            'database_display_name': 'databaseDisplayName',
            'database_type': 'databaseType',
            'database_version': 'databaseVersion',
            'cdb_name': 'cdbName',
            'defined_tags': 'definedTags',
            'freeform_tags': 'freeformTags',
            'processor_count': 'processorCount',
            'database_id': 'databaseId',
            'agent_id': 'agentId',
            'database_connector_id': 'databaseConnectorId'
        }
        self._database_insight_id = None
        self._entity_source = None
        self._compartment_id = None
        self._database_name = None
        self._database_display_name = None
        self._database_type = None
        self._database_version = None
        self._cdb_name = None
        self._defined_tags = None
        self._freeform_tags = None
        self._processor_count = None
        self._database_id = None
        self._agent_id = None
        self._database_connector_id = None
        self._entity_source = 'EXTERNAL_MYSQL_DATABASE_SYSTEM'

    @property
    def database_id(self):
        """
        **[Required]** Gets the database_id of this ExternalMysqlDatabaseConfigurationSummary.
        The `OCID`__ of the database.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The database_id of this ExternalMysqlDatabaseConfigurationSummary.
        :rtype: str
        """
        return self._database_id

    @database_id.setter
    def database_id(self, database_id):
        """
        Sets the database_id of this ExternalMysqlDatabaseConfigurationSummary.
        The `OCID`__ of the database.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param database_id: The database_id of this ExternalMysqlDatabaseConfigurationSummary.
        :type: str
        """
        self._database_id = database_id

    @property
    def agent_id(self):
        """
        **[Required]** Gets the agent_id of this ExternalMysqlDatabaseConfigurationSummary.
        The `OCID`__ of the Management Agent

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The agent_id of this ExternalMysqlDatabaseConfigurationSummary.
        :rtype: str
        """
        return self._agent_id

    @agent_id.setter
    def agent_id(self, agent_id):
        """
        Sets the agent_id of this ExternalMysqlDatabaseConfigurationSummary.
        The `OCID`__ of the Management Agent

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param agent_id: The agent_id of this ExternalMysqlDatabaseConfigurationSummary.
        :type: str
        """
        self._agent_id = agent_id

    @property
    def database_connector_id(self):
        """
        **[Required]** Gets the database_connector_id of this ExternalMysqlDatabaseConfigurationSummary.
        The DBM owned database connector `OCID`__ mapping to the database credentials and connection details.

        __ https://docs.cloud.oracle.com/iaas/database-management/doc/view-connector-details.html


        :return: The database_connector_id of this ExternalMysqlDatabaseConfigurationSummary.
        :rtype: str
        """
        return self._database_connector_id

    @database_connector_id.setter
    def database_connector_id(self, database_connector_id):
        """
        Sets the database_connector_id of this ExternalMysqlDatabaseConfigurationSummary.
        The DBM owned database connector `OCID`__ mapping to the database credentials and connection details.

        __ https://docs.cloud.oracle.com/iaas/database-management/doc/view-connector-details.html


        :param database_connector_id: The database_connector_id of this ExternalMysqlDatabaseConfigurationSummary.
        :type: str
        """
        self._database_connector_id = database_connector_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
