# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220315


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OciCacheDefaultConfigSet(object):
    """
    Default configurations for OCI Cache to manage the behavior, performance, and functionality of the underlying cache engine.
    """

    #: A constant which can be used with the lifecycle_state property of a OciCacheDefaultConfigSet.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a OciCacheDefaultConfigSet.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    def __init__(self, **kwargs):
        """
        Initializes a new OciCacheDefaultConfigSet object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this OciCacheDefaultConfigSet.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this OciCacheDefaultConfigSet.
        :type display_name: str

        :param description:
            The value to assign to the description property of this OciCacheDefaultConfigSet.
        :type description: str

        :param time_created:
            The value to assign to the time_created property of this OciCacheDefaultConfigSet.
        :type time_created: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this OciCacheDefaultConfigSet.
            Allowed values for this property are: "ACTIVE", "INACTIVE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param software_version:
            The value to assign to the software_version property of this OciCacheDefaultConfigSet.
        :type software_version: str

        :param default_configuration_details:
            The value to assign to the default_configuration_details property of this OciCacheDefaultConfigSet.
        :type default_configuration_details: oci.redis.models.DefaultConfigurationDetails

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'description': 'str',
            'time_created': 'datetime',
            'lifecycle_state': 'str',
            'software_version': 'str',
            'default_configuration_details': 'DefaultConfigurationDetails'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'description': 'description',
            'time_created': 'timeCreated',
            'lifecycle_state': 'lifecycleState',
            'software_version': 'softwareVersion',
            'default_configuration_details': 'defaultConfigurationDetails'
        }
        self._id = None
        self._display_name = None
        self._description = None
        self._time_created = None
        self._lifecycle_state = None
        self._software_version = None
        self._default_configuration_details = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this OciCacheDefaultConfigSet.
        The `OCID`__ of the OCI Cache Default Config Set.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle


        :return: The id of this OciCacheDefaultConfigSet.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this OciCacheDefaultConfigSet.
        The `OCID`__ of the OCI Cache Default Config Set.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle


        :param id: The id of this OciCacheDefaultConfigSet.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        Gets the display_name of this OciCacheDefaultConfigSet.
        A user-friendly name of the OCI Cache Default Config Set.


        :return: The display_name of this OciCacheDefaultConfigSet.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this OciCacheDefaultConfigSet.
        A user-friendly name of the OCI Cache Default Config Set.


        :param display_name: The display_name of this OciCacheDefaultConfigSet.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this OciCacheDefaultConfigSet.
        Description of the OCI Cache Default Config Set.


        :return: The description of this OciCacheDefaultConfigSet.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this OciCacheDefaultConfigSet.
        Description of the OCI Cache Default Config Set.


        :param description: The description of this OciCacheDefaultConfigSet.
        :type: str
        """
        self._description = description

    @property
    def time_created(self):
        """
        Gets the time_created of this OciCacheDefaultConfigSet.
        The date and time the OCI Cache Default Config Set was created. An `RFC3339`__ formatted datetime string.

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :return: The time_created of this OciCacheDefaultConfigSet.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this OciCacheDefaultConfigSet.
        The date and time the OCI Cache Default Config Set was created. An `RFC3339`__ formatted datetime string.

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :param time_created: The time_created of this OciCacheDefaultConfigSet.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this OciCacheDefaultConfigSet.
        The current state of the OCI Cache Default Config Set.

        Allowed values for this property are: "ACTIVE", "INACTIVE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this OciCacheDefaultConfigSet.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this OciCacheDefaultConfigSet.
        The current state of the OCI Cache Default Config Set.


        :param lifecycle_state: The lifecycle_state of this OciCacheDefaultConfigSet.
        :type: str
        """
        allowed_values = ["ACTIVE", "INACTIVE"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def software_version(self):
        """
        **[Required]** Gets the software_version of this OciCacheDefaultConfigSet.
        The engine version of the OCI Cache Default Config Set.


        :return: The software_version of this OciCacheDefaultConfigSet.
        :rtype: str
        """
        return self._software_version

    @software_version.setter
    def software_version(self, software_version):
        """
        Sets the software_version of this OciCacheDefaultConfigSet.
        The engine version of the OCI Cache Default Config Set.


        :param software_version: The software_version of this OciCacheDefaultConfigSet.
        :type: str
        """
        self._software_version = software_version

    @property
    def default_configuration_details(self):
        """
        Gets the default_configuration_details of this OciCacheDefaultConfigSet.

        :return: The default_configuration_details of this OciCacheDefaultConfigSet.
        :rtype: oci.redis.models.DefaultConfigurationDetails
        """
        return self._default_configuration_details

    @default_configuration_details.setter
    def default_configuration_details(self, default_configuration_details):
        """
        Sets the default_configuration_details of this OciCacheDefaultConfigSet.

        :param default_configuration_details: The default_configuration_details of this OciCacheDefaultConfigSet.
        :type: oci.redis.models.DefaultConfigurationDetails
        """
        self._default_configuration_details = default_configuration_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
