# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240430

from .resource_filter import ResourceFilter
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class TimeCreatedResourceFilter(ResourceFilter):
    """
    This is a resource filter for filtering resources based on their creation time.
    """

    #: A constant which can be used with the condition property of a TimeCreatedResourceFilter.
    #: This constant has a value of "EQUAL"
    CONDITION_EQUAL = "EQUAL"

    #: A constant which can be used with the condition property of a TimeCreatedResourceFilter.
    #: This constant has a value of "BEFORE"
    CONDITION_BEFORE = "BEFORE"

    #: A constant which can be used with the condition property of a TimeCreatedResourceFilter.
    #: This constant has a value of "AFTER"
    CONDITION_AFTER = "AFTER"

    def __init__(self, **kwargs):
        """
        Initializes a new TimeCreatedResourceFilter object with values from keyword arguments. The default value of the :py:attr:`~oci.resource_scheduler.models.TimeCreatedResourceFilter.attribute` attribute
        of this class is ``TIME_CREATED`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param attribute:
            The value to assign to the attribute property of this TimeCreatedResourceFilter.
            Allowed values for this property are: "COMPARTMENT_ID", "RESOURCE_TYPE", "DEFINED_TAGS", "TIME_CREATED", "LIFECYCLE_STATE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type attribute: str

        :param condition:
            The value to assign to the condition property of this TimeCreatedResourceFilter.
            Allowed values for this property are: "EQUAL", "BEFORE", "AFTER", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type condition: str

        :param value:
            The value to assign to the value property of this TimeCreatedResourceFilter.
        :type value: str

        """
        self.swagger_types = {
            'attribute': 'str',
            'condition': 'str',
            'value': 'str'
        }
        self.attribute_map = {
            'attribute': 'attribute',
            'condition': 'condition',
            'value': 'value'
        }
        self._attribute = None
        self._condition = None
        self._value = None
        self._attribute = 'TIME_CREATED'

    @property
    def condition(self):
        """
        Gets the condition of this TimeCreatedResourceFilter.
        This is the condition for the filter in comparison to its creation time.

        Allowed values for this property are: "EQUAL", "BEFORE", "AFTER", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The condition of this TimeCreatedResourceFilter.
        :rtype: str
        """
        return self._condition

    @condition.setter
    def condition(self, condition):
        """
        Sets the condition of this TimeCreatedResourceFilter.
        This is the condition for the filter in comparison to its creation time.


        :param condition: The condition of this TimeCreatedResourceFilter.
        :type: str
        """
        allowed_values = ["EQUAL", "BEFORE", "AFTER"]
        if not value_allowed_none_or_none_sentinel(condition, allowed_values):
            condition = 'UNKNOWN_ENUM_VALUE'
        self._condition = condition

    @property
    def value(self):
        """
        Gets the value of this TimeCreatedResourceFilter.
        This is the date and time as the value of the filter.


        :return: The value of this TimeCreatedResourceFilter.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this TimeCreatedResourceFilter.
        This is the date and time as the value of the filter.


        :param value: The value of this TimeCreatedResourceFilter.
        :type: str
        """
        self._value = value

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
