# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200909

from .target_details import TargetDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class NotificationsTargetDetails(TargetDetails):
    """
    The destination topic for data transferred from the source.
    For configuration instructions, see
    `Creating a Connector`__.

    __ https://docs.cloud.oracle.com/iaas/Content/connector-hub/create-service-connector.htm
    """

    def __init__(self, **kwargs):
        """
        Initializes a new NotificationsTargetDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.sch.models.NotificationsTargetDetails.kind` attribute
        of this class is ``notifications`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param kind:
            The value to assign to the kind property of this NotificationsTargetDetails.
            Allowed values for this property are: "functions", "loggingAnalytics", "monitoring", "notifications", "objectStorage", "streaming"
        :type kind: str

        :param topic_id:
            The value to assign to the topic_id property of this NotificationsTargetDetails.
        :type topic_id: str

        :param enable_formatted_messaging:
            The value to assign to the enable_formatted_messaging property of this NotificationsTargetDetails.
        :type enable_formatted_messaging: bool

        """
        self.swagger_types = {
            'kind': 'str',
            'topic_id': 'str',
            'enable_formatted_messaging': 'bool'
        }
        self.attribute_map = {
            'kind': 'kind',
            'topic_id': 'topicId',
            'enable_formatted_messaging': 'enableFormattedMessaging'
        }
        self._kind = None
        self._topic_id = None
        self._enable_formatted_messaging = None
        self._kind = 'notifications'

    @property
    def topic_id(self):
        """
        **[Required]** Gets the topic_id of this NotificationsTargetDetails.
        The `OCID`__ of the topic.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The topic_id of this NotificationsTargetDetails.
        :rtype: str
        """
        return self._topic_id

    @topic_id.setter
    def topic_id(self, topic_id):
        """
        Sets the topic_id of this NotificationsTargetDetails.
        The `OCID`__ of the topic.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param topic_id: The topic_id of this NotificationsTargetDetails.
        :type: str
        """
        self._topic_id = topic_id

    @property
    def enable_formatted_messaging(self):
        """
        Gets the enable_formatted_messaging of this NotificationsTargetDetails.
        Whether to apply a simplified, user-friendly format to the message. Applies only when friendly formatting is supported by the connector source and the subscription protocol.
        Example: `true`


        :return: The enable_formatted_messaging of this NotificationsTargetDetails.
        :rtype: bool
        """
        return self._enable_formatted_messaging

    @enable_formatted_messaging.setter
    def enable_formatted_messaging(self, enable_formatted_messaging):
        """
        Sets the enable_formatted_messaging of this NotificationsTargetDetails.
        Whether to apply a simplified, user-friendly format to the message. Applies only when friendly formatting is supported by the connector source and the subscription protocol.
        Example: `true`


        :param enable_formatted_messaging: The enable_formatted_messaging of this NotificationsTargetDetails.
        :type: bool
        """
        self._enable_formatted_messaging = enable_formatted_messaging

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
