# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240815


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SecurityAttribute(object):
    """
    A security attribute that belongs to a specific security attribute namespace. Security attributes must be created in a tenancy before
    a user can apply them to resources.
    For more information, see `Managing Security Attributes`__.

    **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values
    using the API.

    __ https://docs.cloud.oracle.com/Content/zero-trust-packet-routing/managing-security-attributes.htm
    """

    #: A constant which can be used with the lifecycle_state property of a SecurityAttribute.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a SecurityAttribute.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    #: A constant which can be used with the lifecycle_state property of a SecurityAttribute.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a SecurityAttribute.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    def __init__(self, **kwargs):
        """
        Initializes a new SecurityAttribute object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this SecurityAttribute.
        :type compartment_id: str

        :param security_attribute_namespace_id:
            The value to assign to the security_attribute_namespace_id property of this SecurityAttribute.
        :type security_attribute_namespace_id: str

        :param security_attribute_namespace_name:
            The value to assign to the security_attribute_namespace_name property of this SecurityAttribute.
        :type security_attribute_namespace_name: str

        :param id:
            The value to assign to the id property of this SecurityAttribute.
        :type id: str

        :param name:
            The value to assign to the name property of this SecurityAttribute.
        :type name: str

        :param description:
            The value to assign to the description property of this SecurityAttribute.
        :type description: str

        :param type:
            The value to assign to the type property of this SecurityAttribute.
        :type type: str

        :param is_retired:
            The value to assign to the is_retired property of this SecurityAttribute.
        :type is_retired: bool

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this SecurityAttribute.
            Allowed values for this property are: "ACTIVE", "INACTIVE", "DELETING", "DELETED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param time_created:
            The value to assign to the time_created property of this SecurityAttribute.
        :type time_created: datetime

        :param validator:
            The value to assign to the validator property of this SecurityAttribute.
        :type validator: oci.security_attribute.models.BaseSecurityAttributeValidator

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'security_attribute_namespace_id': 'str',
            'security_attribute_namespace_name': 'str',
            'id': 'str',
            'name': 'str',
            'description': 'str',
            'type': 'str',
            'is_retired': 'bool',
            'lifecycle_state': 'str',
            'time_created': 'datetime',
            'validator': 'BaseSecurityAttributeValidator'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'security_attribute_namespace_id': 'securityAttributeNamespaceId',
            'security_attribute_namespace_name': 'securityAttributeNamespaceName',
            'id': 'id',
            'name': 'name',
            'description': 'description',
            'type': 'type',
            'is_retired': 'isRetired',
            'lifecycle_state': 'lifecycleState',
            'time_created': 'timeCreated',
            'validator': 'validator'
        }
        self._compartment_id = None
        self._security_attribute_namespace_id = None
        self._security_attribute_namespace_name = None
        self._id = None
        self._name = None
        self._description = None
        self._type = None
        self._is_retired = None
        self._lifecycle_state = None
        self._time_created = None
        self._validator = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this SecurityAttribute.
        The OCID of the compartment that contains the security attribute definition.


        :return: The compartment_id of this SecurityAttribute.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this SecurityAttribute.
        The OCID of the compartment that contains the security attribute definition.


        :param compartment_id: The compartment_id of this SecurityAttribute.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def security_attribute_namespace_id(self):
        """
        **[Required]** Gets the security_attribute_namespace_id of this SecurityAttribute.
        The OCID of the security attribute namespace that contains the security attribute definition.


        :return: The security_attribute_namespace_id of this SecurityAttribute.
        :rtype: str
        """
        return self._security_attribute_namespace_id

    @security_attribute_namespace_id.setter
    def security_attribute_namespace_id(self, security_attribute_namespace_id):
        """
        Sets the security_attribute_namespace_id of this SecurityAttribute.
        The OCID of the security attribute namespace that contains the security attribute definition.


        :param security_attribute_namespace_id: The security_attribute_namespace_id of this SecurityAttribute.
        :type: str
        """
        self._security_attribute_namespace_id = security_attribute_namespace_id

    @property
    def security_attribute_namespace_name(self):
        """
        **[Required]** Gets the security_attribute_namespace_name of this SecurityAttribute.
        The name of the security attribute namespace that contains the security attribute.


        :return: The security_attribute_namespace_name of this SecurityAttribute.
        :rtype: str
        """
        return self._security_attribute_namespace_name

    @security_attribute_namespace_name.setter
    def security_attribute_namespace_name(self, security_attribute_namespace_name):
        """
        Sets the security_attribute_namespace_name of this SecurityAttribute.
        The name of the security attribute namespace that contains the security attribute.


        :param security_attribute_namespace_name: The security_attribute_namespace_name of this SecurityAttribute.
        :type: str
        """
        self._security_attribute_namespace_name = security_attribute_namespace_name

    @property
    def id(self):
        """
        **[Required]** Gets the id of this SecurityAttribute.
        The OCID of the security attribute definition.


        :return: The id of this SecurityAttribute.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this SecurityAttribute.
        The OCID of the security attribute definition.


        :param id: The id of this SecurityAttribute.
        :type: str
        """
        self._id = id

    @property
    def name(self):
        """
        **[Required]** Gets the name of this SecurityAttribute.
        The name assigned to the security attribute during creation. This is the security attribute key.
        The name must be unique within the security attribute namespace and cannot be changed.


        :return: The name of this SecurityAttribute.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this SecurityAttribute.
        The name assigned to the security attribute during creation. This is the security attribute key.
        The name must be unique within the security attribute namespace and cannot be changed.


        :param name: The name of this SecurityAttribute.
        :type: str
        """
        self._name = name

    @property
    def description(self):
        """
        **[Required]** Gets the description of this SecurityAttribute.
        The description of the security attribute.


        :return: The description of this SecurityAttribute.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this SecurityAttribute.
        The description of the security attribute.


        :param description: The description of this SecurityAttribute.
        :type: str
        """
        self._description = description

    @property
    def type(self):
        """
        Gets the type of this SecurityAttribute.
        The data type of the security attribute.


        :return: The type of this SecurityAttribute.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this SecurityAttribute.
        The data type of the security attribute.


        :param type: The type of this SecurityAttribute.
        :type: str
        """
        self._type = type

    @property
    def is_retired(self):
        """
        **[Required]** Gets the is_retired of this SecurityAttribute.
        Indicates whether the security attribute is retired.
        See `Managing Security Attribute Namespaces`__.

        __ https://docs.cloud.oracle.com/Content/zero-trust-packet-routing/managing-security-attribute-namespaces.htm


        :return: The is_retired of this SecurityAttribute.
        :rtype: bool
        """
        return self._is_retired

    @is_retired.setter
    def is_retired(self, is_retired):
        """
        Sets the is_retired of this SecurityAttribute.
        Indicates whether the security attribute is retired.
        See `Managing Security Attribute Namespaces`__.

        __ https://docs.cloud.oracle.com/Content/zero-trust-packet-routing/managing-security-attribute-namespaces.htm


        :param is_retired: The is_retired of this SecurityAttribute.
        :type: bool
        """
        self._is_retired = is_retired

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this SecurityAttribute.
        The security attribute's current state. After creating a security attribute, make sure its `lifecycleState` is ACTIVE before using it. After retiring a security attribute, make sure its `lifecycleState` is INACTIVE before using it. If you delete a security attribute, you cannot delete another security attribute until the deleted tag's `lifecycleState` changes from DELETING to DELETED.

        Allowed values for this property are: "ACTIVE", "INACTIVE", "DELETING", "DELETED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this SecurityAttribute.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this SecurityAttribute.
        The security attribute's current state. After creating a security attribute, make sure its `lifecycleState` is ACTIVE before using it. After retiring a security attribute, make sure its `lifecycleState` is INACTIVE before using it. If you delete a security attribute, you cannot delete another security attribute until the deleted tag's `lifecycleState` changes from DELETING to DELETED.


        :param lifecycle_state: The lifecycle_state of this SecurityAttribute.
        :type: str
        """
        allowed_values = ["ACTIVE", "INACTIVE", "DELETING", "DELETED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this SecurityAttribute.
        Date and time the security attribute was created, in the format defined by RFC3339.

        Example: `2016-08-25T21:10:29.600Z`


        :return: The time_created of this SecurityAttribute.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this SecurityAttribute.
        Date and time the security attribute was created, in the format defined by RFC3339.

        Example: `2016-08-25T21:10:29.600Z`


        :param time_created: The time_created of this SecurityAttribute.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def validator(self):
        """
        Gets the validator of this SecurityAttribute.

        :return: The validator of this SecurityAttribute.
        :rtype: oci.security_attribute.models.BaseSecurityAttributeValidator
        """
        return self._validator

    @validator.setter
    def validator(self, validator):
        """
        Sets the validator of this SecurityAttribute.

        :param validator: The validator of this SecurityAttribute.
        :type: oci.security_attribute.models.BaseSecurityAttributeValidator
        """
        self._validator = validator

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
