# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20221001


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Capabilities(object):
    """
    Capabilities supported
    """

    def __init__(self, **kwargs):
        """
        Initializes a new Capabilities object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param capability:
            The value to assign to the capability property of this Capabilities.
        :type capability: dict(str, Capability)

        """
        self.swagger_types = {
            'capability': 'dict(str, Capability)'
        }
        self.attribute_map = {
            'capability': 'capability'
        }
        self._capability = None

    @property
    def capability(self):
        """
        Gets the capability of this Capabilities.
        Model information capabilities related to version


        :return: The capability of this Capabilities.
        :rtype: dict(str, Capability)
        """
        return self._capability

    @capability.setter
    def capability(self, capability):
        """
        Sets the capability of this Capabilities.
        Model information capabilities related to version


        :param capability: The capability of this Capabilities.
        :type: dict(str, Capability)
        """
        self._capability = capability

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
