# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreatePrivilegedApiControlDetails(object):
    """
    The data to create a PrivilegedApiControl.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreatePrivilegedApiControlDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CreatePrivilegedApiControlDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this CreatePrivilegedApiControlDetails.
        :type description: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreatePrivilegedApiControlDetails.
        :type compartment_id: str

        :param notification_topic_id:
            The value to assign to the notification_topic_id property of this CreatePrivilegedApiControlDetails.
        :type notification_topic_id: str

        :param approver_group_id_list:
            The value to assign to the approver_group_id_list property of this CreatePrivilegedApiControlDetails.
        :type approver_group_id_list: list[str]

        :param privileged_operation_list:
            The value to assign to the privileged_operation_list property of this CreatePrivilegedApiControlDetails.
        :type privileged_operation_list: list[oci.apiaccesscontrol.models.PrivilegedApiDetails]

        :param resource_type:
            The value to assign to the resource_type property of this CreatePrivilegedApiControlDetails.
        :type resource_type: str

        :param resources:
            The value to assign to the resources property of this CreatePrivilegedApiControlDetails.
        :type resources: list[str]

        :param number_of_approvers:
            The value to assign to the number_of_approvers property of this CreatePrivilegedApiControlDetails.
        :type number_of_approvers: int

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreatePrivilegedApiControlDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreatePrivilegedApiControlDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'description': 'str',
            'compartment_id': 'str',
            'notification_topic_id': 'str',
            'approver_group_id_list': 'list[str]',
            'privileged_operation_list': 'list[PrivilegedApiDetails]',
            'resource_type': 'str',
            'resources': 'list[str]',
            'number_of_approvers': 'int',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'description': 'description',
            'compartment_id': 'compartmentId',
            'notification_topic_id': 'notificationTopicId',
            'approver_group_id_list': 'approverGroupIdList',
            'privileged_operation_list': 'privilegedOperationList',
            'resource_type': 'resourceType',
            'resources': 'resources',
            'number_of_approvers': 'numberOfApprovers',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._display_name = None
        self._description = None
        self._compartment_id = None
        self._notification_topic_id = None
        self._approver_group_id_list = None
        self._privileged_operation_list = None
        self._resource_type = None
        self._resources = None
        self._number_of_approvers = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        Gets the display_name of this CreatePrivilegedApiControlDetails.
        Name of the privilegedApi control It has to be unique.


        :return: The display_name of this CreatePrivilegedApiControlDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreatePrivilegedApiControlDetails.
        Name of the privilegedApi control It has to be unique.


        :param display_name: The display_name of this CreatePrivilegedApiControlDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this CreatePrivilegedApiControlDetails.
        Description of the privilegedApi control.


        :return: The description of this CreatePrivilegedApiControlDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreatePrivilegedApiControlDetails.
        Description of the privilegedApi control.


        :param description: The description of this CreatePrivilegedApiControlDetails.
        :type: str
        """
        self._description = description

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreatePrivilegedApiControlDetails.
        The `OCID`__ of the compartment to create the PrivilegedApiControl in.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreatePrivilegedApiControlDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreatePrivilegedApiControlDetails.
        The `OCID`__ of the compartment to create the PrivilegedApiControl in.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreatePrivilegedApiControlDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def notification_topic_id(self):
        """
        **[Required]** Gets the notification_topic_id of this CreatePrivilegedApiControlDetails.
        The OCID of the OCI Notification topic to publish messages related to this Delegation Control.


        :return: The notification_topic_id of this CreatePrivilegedApiControlDetails.
        :rtype: str
        """
        return self._notification_topic_id

    @notification_topic_id.setter
    def notification_topic_id(self, notification_topic_id):
        """
        Sets the notification_topic_id of this CreatePrivilegedApiControlDetails.
        The OCID of the OCI Notification topic to publish messages related to this Delegation Control.


        :param notification_topic_id: The notification_topic_id of this CreatePrivilegedApiControlDetails.
        :type: str
        """
        self._notification_topic_id = notification_topic_id

    @property
    def approver_group_id_list(self):
        """
        **[Required]** Gets the approver_group_id_list of this CreatePrivilegedApiControlDetails.
        List of user IAM group ids who can approve an privilegedApi request associated with a resource governed by this operator control.


        :return: The approver_group_id_list of this CreatePrivilegedApiControlDetails.
        :rtype: list[str]
        """
        return self._approver_group_id_list

    @approver_group_id_list.setter
    def approver_group_id_list(self, approver_group_id_list):
        """
        Sets the approver_group_id_list of this CreatePrivilegedApiControlDetails.
        List of user IAM group ids who can approve an privilegedApi request associated with a resource governed by this operator control.


        :param approver_group_id_list: The approver_group_id_list of this CreatePrivilegedApiControlDetails.
        :type: list[str]
        """
        self._approver_group_id_list = approver_group_id_list

    @property
    def privileged_operation_list(self):
        """
        **[Required]** Gets the privileged_operation_list of this CreatePrivilegedApiControlDetails.
        List of privileged operator operations. If Privileged API Managment is enabled for a resource it will be validated whether the operation done by the operator is a part of privileged operation.


        :return: The privileged_operation_list of this CreatePrivilegedApiControlDetails.
        :rtype: list[oci.apiaccesscontrol.models.PrivilegedApiDetails]
        """
        return self._privileged_operation_list

    @privileged_operation_list.setter
    def privileged_operation_list(self, privileged_operation_list):
        """
        Sets the privileged_operation_list of this CreatePrivilegedApiControlDetails.
        List of privileged operator operations. If Privileged API Managment is enabled for a resource it will be validated whether the operation done by the operator is a part of privileged operation.


        :param privileged_operation_list: The privileged_operation_list of this CreatePrivilegedApiControlDetails.
        :type: list[oci.apiaccesscontrol.models.PrivilegedApiDetails]
        """
        self._privileged_operation_list = privileged_operation_list

    @property
    def resource_type(self):
        """
        **[Required]** Gets the resource_type of this CreatePrivilegedApiControlDetails.
        resourceType for which the PrivilegedApiControl is applicable


        :return: The resource_type of this CreatePrivilegedApiControlDetails.
        :rtype: str
        """
        return self._resource_type

    @resource_type.setter
    def resource_type(self, resource_type):
        """
        Sets the resource_type of this CreatePrivilegedApiControlDetails.
        resourceType for which the PrivilegedApiControl is applicable


        :param resource_type: The resource_type of this CreatePrivilegedApiControlDetails.
        :type: str
        """
        self._resource_type = resource_type

    @property
    def resources(self):
        """
        **[Required]** Gets the resources of this CreatePrivilegedApiControlDetails.
        contains Resource details


        :return: The resources of this CreatePrivilegedApiControlDetails.
        :rtype: list[str]
        """
        return self._resources

    @resources.setter
    def resources(self, resources):
        """
        Sets the resources of this CreatePrivilegedApiControlDetails.
        contains Resource details


        :param resources: The resources of this CreatePrivilegedApiControlDetails.
        :type: list[str]
        """
        self._resources = resources

    @property
    def number_of_approvers(self):
        """
        Gets the number_of_approvers of this CreatePrivilegedApiControlDetails.
        Number of approvers required to approve an privilegedApi request.


        :return: The number_of_approvers of this CreatePrivilegedApiControlDetails.
        :rtype: int
        """
        return self._number_of_approvers

    @number_of_approvers.setter
    def number_of_approvers(self, number_of_approvers):
        """
        Sets the number_of_approvers of this CreatePrivilegedApiControlDetails.
        Number of approvers required to approve an privilegedApi request.


        :param number_of_approvers: The number_of_approvers of this CreatePrivilegedApiControlDetails.
        :type: int
        """
        self._number_of_approvers = number_of_approvers

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreatePrivilegedApiControlDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreatePrivilegedApiControlDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreatePrivilegedApiControlDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreatePrivilegedApiControlDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreatePrivilegedApiControlDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreatePrivilegedApiControlDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreatePrivilegedApiControlDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreatePrivilegedApiControlDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
