# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190501


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Ipv6AddressConfiguration(object):
    """
    IPv6 address configuration details that should be used when creating the gateway.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new Ipv6AddressConfiguration object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param addresses:
            The value to assign to the addresses property of this Ipv6AddressConfiguration.
        :type addresses: list[str]

        :param subnet_cidrs:
            The value to assign to the subnet_cidrs property of this Ipv6AddressConfiguration.
        :type subnet_cidrs: list[str]

        """
        self.swagger_types = {
            'addresses': 'list[str]',
            'subnet_cidrs': 'list[str]'
        }
        self.attribute_map = {
            'addresses': 'addresses',
            'subnet_cidrs': 'subnetCidrs'
        }
        self._addresses = None
        self._subnet_cidrs = None

    @property
    def addresses(self):
        """
        Gets the addresses of this Ipv6AddressConfiguration.
        List of IPv6 addresses that will be assigned to the gateway during creation.


        :return: The addresses of this Ipv6AddressConfiguration.
        :rtype: list[str]
        """
        return self._addresses

    @addresses.setter
    def addresses(self, addresses):
        """
        Sets the addresses of this Ipv6AddressConfiguration.
        List of IPv6 addresses that will be assigned to the gateway during creation.


        :param addresses: The addresses of this Ipv6AddressConfiguration.
        :type: list[str]
        """
        self._addresses = addresses

    @property
    def subnet_cidrs(self):
        """
        Gets the subnet_cidrs of this Ipv6AddressConfiguration.
        List of IPv6 prefixes from which to provision IPv6 addresses from. This is required if more than one prefix exists on the subnet.


        :return: The subnet_cidrs of this Ipv6AddressConfiguration.
        :rtype: list[str]
        """
        return self._subnet_cidrs

    @subnet_cidrs.setter
    def subnet_cidrs(self, subnet_cidrs):
        """
        Sets the subnet_cidrs of this Ipv6AddressConfiguration.
        List of IPv6 prefixes from which to provision IPv6 addresses from. This is required if more than one prefix exists on the subnet.


        :param subnet_cidrs: The subnet_cidrs of this Ipv6AddressConfiguration.
        :type: list[str]
        """
        self._subnet_cidrs = subnet_cidrs

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
