# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20251031


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BatchTaskEnvironment(object):
    """
    A batch task environment resource defines the software that is used to execute tasks.
    It mainly contains a URL to a container image along with other configurations that are needed by the image.

    To use any of the API operations, you must be authorized in an IAM policy. If you're not authorized, talk to
    an administrator. If you're an administrator who needs to write policies to give users access, see
    `Getting Started with Policies`__.

    __ https://docs.cloud.oracle.com/iaas/Content/Identity/policiesgs/get-started-with-policies.htm
    """

    #: A constant which can be used with the lifecycle_state property of a BatchTaskEnvironment.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a BatchTaskEnvironment.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    def __init__(self, **kwargs):
        """
        Initializes a new BatchTaskEnvironment object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this BatchTaskEnvironment.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this BatchTaskEnvironment.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this BatchTaskEnvironment.
        :type display_name: str

        :param description:
            The value to assign to the description property of this BatchTaskEnvironment.
        :type description: str

        :param image_url:
            The value to assign to the image_url property of this BatchTaskEnvironment.
        :type image_url: str

        :param security_context:
            The value to assign to the security_context property of this BatchTaskEnvironment.
        :type security_context: oci.batch.models.SecurityContext

        :param working_directory:
            The value to assign to the working_directory property of this BatchTaskEnvironment.
        :type working_directory: str

        :param volumes:
            The value to assign to the volumes property of this BatchTaskEnvironment.
        :type volumes: list[oci.batch.models.BatchTaskEnvironmentVolume]

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this BatchTaskEnvironment.
            Allowed values for this property are: "ACTIVE", "DELETED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param time_created:
            The value to assign to the time_created property of this BatchTaskEnvironment.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this BatchTaskEnvironment.
        :type time_updated: datetime

        :param defined_tags:
            The value to assign to the defined_tags property of this BatchTaskEnvironment.
        :type defined_tags: dict(str, dict(str, object))

        :param freeform_tags:
            The value to assign to the freeform_tags property of this BatchTaskEnvironment.
        :type freeform_tags: dict(str, str)

        :param system_tags:
            The value to assign to the system_tags property of this BatchTaskEnvironment.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'display_name': 'str',
            'description': 'str',
            'image_url': 'str',
            'security_context': 'SecurityContext',
            'working_directory': 'str',
            'volumes': 'list[BatchTaskEnvironmentVolume]',
            'lifecycle_state': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'defined_tags': 'dict(str, dict(str, object))',
            'freeform_tags': 'dict(str, str)',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'description': 'description',
            'image_url': 'imageUrl',
            'security_context': 'securityContext',
            'working_directory': 'workingDirectory',
            'volumes': 'volumes',
            'lifecycle_state': 'lifecycleState',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'defined_tags': 'definedTags',
            'freeform_tags': 'freeformTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._compartment_id = None
        self._display_name = None
        self._description = None
        self._image_url = None
        self._security_context = None
        self._working_directory = None
        self._volumes = None
        self._lifecycle_state = None
        self._time_created = None
        self._time_updated = None
        self._defined_tags = None
        self._freeform_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this BatchTaskEnvironment.
        The `OCID`__ of the batch task environment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this BatchTaskEnvironment.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this BatchTaskEnvironment.
        The `OCID`__ of the batch task environment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this BatchTaskEnvironment.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this BatchTaskEnvironment.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this BatchTaskEnvironment.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this BatchTaskEnvironment.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this BatchTaskEnvironment.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this BatchTaskEnvironment.
        A user-friendly name. Does not have to be unique, and it's changeable.
        If not specified or provided as null or empty string, it be generated as \"<resourceType><timeCreated>\", where timeCreated corresponds with the resource creation time in ISO 8601 basic format, i.e. omitting separating punctuation, at second-level precision and no UTC offset. Example: batchtaskenvironment20250914115623.


        :return: The display_name of this BatchTaskEnvironment.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this BatchTaskEnvironment.
        A user-friendly name. Does not have to be unique, and it's changeable.
        If not specified or provided as null or empty string, it be generated as \"<resourceType><timeCreated>\", where timeCreated corresponds with the resource creation time in ISO 8601 basic format, i.e. omitting separating punctuation, at second-level precision and no UTC offset. Example: batchtaskenvironment20250914115623.


        :param display_name: The display_name of this BatchTaskEnvironment.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this BatchTaskEnvironment.
        The batch task environment description.


        :return: The description of this BatchTaskEnvironment.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this BatchTaskEnvironment.
        The batch task environment description.


        :param description: The description of this BatchTaskEnvironment.
        :type: str
        """
        self._description = description

    @property
    def image_url(self):
        """
        **[Required]** Gets the image_url of this BatchTaskEnvironment.
        The URL of the ocir image.


        :return: The image_url of this BatchTaskEnvironment.
        :rtype: str
        """
        return self._image_url

    @image_url.setter
    def image_url(self, image_url):
        """
        Sets the image_url of this BatchTaskEnvironment.
        The URL of the ocir image.


        :param image_url: The image_url of this BatchTaskEnvironment.
        :type: str
        """
        self._image_url = image_url

    @property
    def security_context(self):
        """
        Gets the security_context of this BatchTaskEnvironment.

        :return: The security_context of this BatchTaskEnvironment.
        :rtype: oci.batch.models.SecurityContext
        """
        return self._security_context

    @security_context.setter
    def security_context(self, security_context):
        """
        Sets the security_context of this BatchTaskEnvironment.

        :param security_context: The security_context of this BatchTaskEnvironment.
        :type: oci.batch.models.SecurityContext
        """
        self._security_context = security_context

    @property
    def working_directory(self):
        """
        Gets the working_directory of this BatchTaskEnvironment.
        Container's working directory.


        :return: The working_directory of this BatchTaskEnvironment.
        :rtype: str
        """
        return self._working_directory

    @working_directory.setter
    def working_directory(self, working_directory):
        """
        Sets the working_directory of this BatchTaskEnvironment.
        Container's working directory.


        :param working_directory: The working_directory of this BatchTaskEnvironment.
        :type: str
        """
        self._working_directory = working_directory

    @property
    def volumes(self):
        """
        **[Required]** Gets the volumes of this BatchTaskEnvironment.
        List of volumes attached to the image.
        The use cases of the volumes are but not limited to: read the input of the task and write the output.


        :return: The volumes of this BatchTaskEnvironment.
        :rtype: list[oci.batch.models.BatchTaskEnvironmentVolume]
        """
        return self._volumes

    @volumes.setter
    def volumes(self, volumes):
        """
        Sets the volumes of this BatchTaskEnvironment.
        List of volumes attached to the image.
        The use cases of the volumes are but not limited to: read the input of the task and write the output.


        :param volumes: The volumes of this BatchTaskEnvironment.
        :type: list[oci.batch.models.BatchTaskEnvironmentVolume]
        """
        self._volumes = volumes

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this BatchTaskEnvironment.
        The current state of the batch task environment.

        Allowed values for this property are: "ACTIVE", "DELETED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this BatchTaskEnvironment.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this BatchTaskEnvironment.
        The current state of the batch task environment.


        :param lifecycle_state: The lifecycle_state of this BatchTaskEnvironment.
        :type: str
        """
        allowed_values = ["ACTIVE", "DELETED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this BatchTaskEnvironment.
        The date and time the batch task environment was created, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this BatchTaskEnvironment.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this BatchTaskEnvironment.
        The date and time the batch task environment was created, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this BatchTaskEnvironment.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this BatchTaskEnvironment.
        The date and time the batch task environment was updated, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this BatchTaskEnvironment.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this BatchTaskEnvironment.
        The date and time the batch task environment was updated, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this BatchTaskEnvironment.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def defined_tags(self):
        """
        **[Required]** Gets the defined_tags of this BatchTaskEnvironment.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this BatchTaskEnvironment.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this BatchTaskEnvironment.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this BatchTaskEnvironment.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def freeform_tags(self):
        """
        **[Required]** Gets the freeform_tags of this BatchTaskEnvironment.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this BatchTaskEnvironment.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this BatchTaskEnvironment.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this BatchTaskEnvironment.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def system_tags(self):
        """
        **[Required]** Gets the system_tags of this BatchTaskEnvironment.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this BatchTaskEnvironment.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this BatchTaskEnvironment.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this BatchTaskEnvironment.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
