# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20251031

from .batch_task import BatchTask
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ComputeTask(BatchTask):
    """
    compute task represents a single executable command together with its dependencies and resources.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ComputeTask object with values from keyword arguments. The default value of the :py:attr:`~oci.batch.models.ComputeTask.type` attribute
        of this class is ``COMPUTE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this ComputeTask.
        :type id: str

        :param name:
            The value to assign to the name property of this ComputeTask.
        :type name: str

        :param description:
            The value to assign to the description property of this ComputeTask.
        :type description: str

        :param type:
            The value to assign to the type property of this ComputeTask.
            Allowed values for this property are: "COMPUTE"
        :type type: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this ComputeTask.
            Allowed values for this property are: "ACCEPTED", "WAITING", "IN_PROGRESS", "SUCCEEDED", "FAILED", "CANCELING", "CANCELED"
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this ComputeTask.
        :type lifecycle_details: str

        :param entitlement_claims:
            The value to assign to the entitlement_claims property of this ComputeTask.
        :type entitlement_claims: list[str]

        :param dependencies:
            The value to assign to the dependencies property of this ComputeTask.
        :type dependencies: list[str]

        :param environment_variables:
            The value to assign to the environment_variables property of this ComputeTask.
        :type environment_variables: list[oci.batch.models.EnvironmentVariable]

        :param batch_task_profile_id:
            The value to assign to the batch_task_profile_id property of this ComputeTask.
        :type batch_task_profile_id: str

        :param command:
            The value to assign to the command property of this ComputeTask.
        :type command: list[str]

        :param arguments:
            The value to assign to the arguments property of this ComputeTask.
        :type arguments: list[str]

        :param fleet_assignment_policy:
            The value to assign to the fleet_assignment_policy property of this ComputeTask.
        :type fleet_assignment_policy: oci.batch.models.FleetAssignmentPolicy

        :param batch_task_environment_id:
            The value to assign to the batch_task_environment_id property of this ComputeTask.
        :type batch_task_environment_id: str

        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'description': 'str',
            'type': 'str',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'entitlement_claims': 'list[str]',
            'dependencies': 'list[str]',
            'environment_variables': 'list[EnvironmentVariable]',
            'batch_task_profile_id': 'str',
            'command': 'list[str]',
            'arguments': 'list[str]',
            'fleet_assignment_policy': 'FleetAssignmentPolicy',
            'batch_task_environment_id': 'str'
        }
        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'description': 'description',
            'type': 'type',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'entitlement_claims': 'entitlementClaims',
            'dependencies': 'dependencies',
            'environment_variables': 'environmentVariables',
            'batch_task_profile_id': 'batchTaskProfileId',
            'command': 'command',
            'arguments': 'arguments',
            'fleet_assignment_policy': 'fleetAssignmentPolicy',
            'batch_task_environment_id': 'batchTaskEnvironmentId'
        }
        self._id = None
        self._name = None
        self._description = None
        self._type = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._entitlement_claims = None
        self._dependencies = None
        self._environment_variables = None
        self._batch_task_profile_id = None
        self._command = None
        self._arguments = None
        self._fleet_assignment_policy = None
        self._batch_task_environment_id = None
        self._type = 'COMPUTE'

    @property
    def batch_task_profile_id(self):
        """
        Gets the batch_task_profile_id of this ComputeTask.
        The `OCID`__ of the batch task profile used for this task.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The batch_task_profile_id of this ComputeTask.
        :rtype: str
        """
        return self._batch_task_profile_id

    @batch_task_profile_id.setter
    def batch_task_profile_id(self, batch_task_profile_id):
        """
        Sets the batch_task_profile_id of this ComputeTask.
        The `OCID`__ of the batch task profile used for this task.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param batch_task_profile_id: The batch_task_profile_id of this ComputeTask.
        :type: str
        """
        self._batch_task_profile_id = batch_task_profile_id

    @property
    def command(self):
        """
        Gets the command of this ComputeTask.
        An executable command to start the processing of this task.


        :return: The command of this ComputeTask.
        :rtype: list[str]
        """
        return self._command

    @command.setter
    def command(self, command):
        """
        Sets the command of this ComputeTask.
        An executable command to start the processing of this task.


        :param command: The command of this ComputeTask.
        :type: list[str]
        """
        self._command = command

    @property
    def arguments(self):
        """
        Gets the arguments of this ComputeTask.
        Task arguments.


        :return: The arguments of this ComputeTask.
        :rtype: list[str]
        """
        return self._arguments

    @arguments.setter
    def arguments(self, arguments):
        """
        Sets the arguments of this ComputeTask.
        Task arguments.


        :param arguments: The arguments of this ComputeTask.
        :type: list[str]
        """
        self._arguments = arguments

    @property
    def fleet_assignment_policy(self):
        """
        Gets the fleet_assignment_policy of this ComputeTask.

        :return: The fleet_assignment_policy of this ComputeTask.
        :rtype: oci.batch.models.FleetAssignmentPolicy
        """
        return self._fleet_assignment_policy

    @fleet_assignment_policy.setter
    def fleet_assignment_policy(self, fleet_assignment_policy):
        """
        Sets the fleet_assignment_policy of this ComputeTask.

        :param fleet_assignment_policy: The fleet_assignment_policy of this ComputeTask.
        :type: oci.batch.models.FleetAssignmentPolicy
        """
        self._fleet_assignment_policy = fleet_assignment_policy

    @property
    def batch_task_environment_id(self):
        """
        **[Required]** Gets the batch_task_environment_id of this ComputeTask.
        The `OCID`__ of the BatchTaskEnvironment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The batch_task_environment_id of this ComputeTask.
        :rtype: str
        """
        return self._batch_task_environment_id

    @batch_task_environment_id.setter
    def batch_task_environment_id(self, batch_task_environment_id):
        """
        Sets the batch_task_environment_id of this ComputeTask.
        The `OCID`__ of the BatchTaskEnvironment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param batch_task_environment_id: The batch_task_environment_id of this ComputeTask.
        :type: str
        """
        self._batch_task_environment_id = batch_task_environment_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
