# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20251031


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateBatchContextDetails(object):
    """
    The data to create a batch context.
    If the value for a collection is absent or is explicitly provided as null, it will be converted to an empty value, i.e. \"[]\" or \"{}\" in json notation. This applies to nested collections as well.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateBatchContextDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateBatchContextDetails.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this CreateBatchContextDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this CreateBatchContextDetails.
        :type description: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateBatchContextDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateBatchContextDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param job_priority_configurations:
            The value to assign to the job_priority_configurations property of this CreateBatchContextDetails.
        :type job_priority_configurations: list[oci.batch.models.JobPriorityConfiguration]

        :param network:
            The value to assign to the network property of this CreateBatchContextDetails.
        :type network: oci.batch.models.CreateNetworkDetails

        :param fleets:
            The value to assign to the fleets property of this CreateBatchContextDetails.
        :type fleets: list[oci.batch.models.CreateFleetDetails]

        :param entitlements:
            The value to assign to the entitlements property of this CreateBatchContextDetails.
        :type entitlements: dict(str, int)

        :param logging_configuration:
            The value to assign to the logging_configuration property of this CreateBatchContextDetails.
        :type logging_configuration: oci.batch.models.LoggingConfiguration

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'display_name': 'str',
            'description': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'job_priority_configurations': 'list[JobPriorityConfiguration]',
            'network': 'CreateNetworkDetails',
            'fleets': 'list[CreateFleetDetails]',
            'entitlements': 'dict(str, int)',
            'logging_configuration': 'LoggingConfiguration'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'description': 'description',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'job_priority_configurations': 'jobPriorityConfigurations',
            'network': 'network',
            'fleets': 'fleets',
            'entitlements': 'entitlements',
            'logging_configuration': 'loggingConfiguration'
        }
        self._compartment_id = None
        self._display_name = None
        self._description = None
        self._freeform_tags = None
        self._defined_tags = None
        self._job_priority_configurations = None
        self._network = None
        self._fleets = None
        self._entitlements = None
        self._logging_configuration = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateBatchContextDetails.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateBatchContextDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateBatchContextDetails.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateBatchContextDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateBatchContextDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        If not specified or provided as null or empty string, it will be generated as \"<resourceType><timeCreated>\", where timeCreated corresponds with the resource creation time in ISO 8601 basic format, i.e. omitting separating punctuation, at second-level precision and no UTC offset. Example: batchcontext20250914115623.


        :return: The display_name of this CreateBatchContextDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateBatchContextDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        If not specified or provided as null or empty string, it will be generated as \"<resourceType><timeCreated>\", where timeCreated corresponds with the resource creation time in ISO 8601 basic format, i.e. omitting separating punctuation, at second-level precision and no UTC offset. Example: batchcontext20250914115623.


        :param display_name: The display_name of this CreateBatchContextDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this CreateBatchContextDetails.
        Summarized information about the batch context.


        :return: The description of this CreateBatchContextDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateBatchContextDetails.
        Summarized information about the batch context.


        :param description: The description of this CreateBatchContextDetails.
        :type: str
        """
        self._description = description

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateBatchContextDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateBatchContextDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateBatchContextDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateBatchContextDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateBatchContextDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateBatchContextDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateBatchContextDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateBatchContextDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def job_priority_configurations(self):
        """
        Gets the job_priority_configurations of this CreateBatchContextDetails.
        List of job priority configurations related to the batch context.


        :return: The job_priority_configurations of this CreateBatchContextDetails.
        :rtype: list[oci.batch.models.JobPriorityConfiguration]
        """
        return self._job_priority_configurations

    @job_priority_configurations.setter
    def job_priority_configurations(self, job_priority_configurations):
        """
        Sets the job_priority_configurations of this CreateBatchContextDetails.
        List of job priority configurations related to the batch context.


        :param job_priority_configurations: The job_priority_configurations of this CreateBatchContextDetails.
        :type: list[oci.batch.models.JobPriorityConfiguration]
        """
        self._job_priority_configurations = job_priority_configurations

    @property
    def network(self):
        """
        **[Required]** Gets the network of this CreateBatchContextDetails.

        :return: The network of this CreateBatchContextDetails.
        :rtype: oci.batch.models.CreateNetworkDetails
        """
        return self._network

    @network.setter
    def network(self, network):
        """
        Sets the network of this CreateBatchContextDetails.

        :param network: The network of this CreateBatchContextDetails.
        :type: oci.batch.models.CreateNetworkDetails
        """
        self._network = network

    @property
    def fleets(self):
        """
        **[Required]** Gets the fleets of this CreateBatchContextDetails.
        List of fleet configurations related to the batch context.


        :return: The fleets of this CreateBatchContextDetails.
        :rtype: list[oci.batch.models.CreateFleetDetails]
        """
        return self._fleets

    @fleets.setter
    def fleets(self, fleets):
        """
        Sets the fleets of this CreateBatchContextDetails.
        List of fleet configurations related to the batch context.


        :param fleets: The fleets of this CreateBatchContextDetails.
        :type: list[oci.batch.models.CreateFleetDetails]
        """
        self._fleets = fleets

    @property
    def entitlements(self):
        """
        Gets the entitlements of this CreateBatchContextDetails.
        Mapping of concurrent/shared resources used in job tasks to their limits.


        :return: The entitlements of this CreateBatchContextDetails.
        :rtype: dict(str, int)
        """
        return self._entitlements

    @entitlements.setter
    def entitlements(self, entitlements):
        """
        Sets the entitlements of this CreateBatchContextDetails.
        Mapping of concurrent/shared resources used in job tasks to their limits.


        :param entitlements: The entitlements of this CreateBatchContextDetails.
        :type: dict(str, int)
        """
        self._entitlements = entitlements

    @property
    def logging_configuration(self):
        """
        Gets the logging_configuration of this CreateBatchContextDetails.

        :return: The logging_configuration of this CreateBatchContextDetails.
        :rtype: oci.batch.models.LoggingConfiguration
        """
        return self._logging_configuration

    @logging_configuration.setter
    def logging_configuration(self, logging_configuration):
        """
        Sets the logging_configuration of this CreateBatchContextDetails.

        :param logging_configuration: The logging_configuration of this CreateBatchContextDetails.
        :type: oci.batch.models.LoggingConfiguration
        """
        self._logging_configuration = logging_configuration

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
