# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20251031


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateBatchJobDetails(object):
    """
    The data to create a batch job.
    If the value for a collection is absent or is explicitly provided as null, it will be converted to an empty value, i.e. \"[]\" or \"{}\" in json notation. This applies to nested collections as well.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateBatchJobDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateBatchJobDetails.
        :type compartment_id: str

        :param batch_job_pool_id:
            The value to assign to the batch_job_pool_id property of this CreateBatchJobDetails.
        :type batch_job_pool_id: str

        :param display_name:
            The value to assign to the display_name property of this CreateBatchJobDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this CreateBatchJobDetails.
        :type description: str

        :param environment_variables:
            The value to assign to the environment_variables property of this CreateBatchJobDetails.
        :type environment_variables: list[oci.batch.models.EnvironmentVariable]

        :param tasks:
            The value to assign to the tasks property of this CreateBatchJobDetails.
        :type tasks: list[oci.batch.models.CreateBatchTaskDetails]

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateBatchJobDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateBatchJobDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'batch_job_pool_id': 'str',
            'display_name': 'str',
            'description': 'str',
            'environment_variables': 'list[EnvironmentVariable]',
            'tasks': 'list[CreateBatchTaskDetails]',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'batch_job_pool_id': 'batchJobPoolId',
            'display_name': 'displayName',
            'description': 'description',
            'environment_variables': 'environmentVariables',
            'tasks': 'tasks',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._compartment_id = None
        self._batch_job_pool_id = None
        self._display_name = None
        self._description = None
        self._environment_variables = None
        self._tasks = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateBatchJobDetails.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateBatchJobDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateBatchJobDetails.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateBatchJobDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def batch_job_pool_id(self):
        """
        **[Required]** Gets the batch_job_pool_id of this CreateBatchJobDetails.
        The `OCID`__ of the parent batch job pool.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The batch_job_pool_id of this CreateBatchJobDetails.
        :rtype: str
        """
        return self._batch_job_pool_id

    @batch_job_pool_id.setter
    def batch_job_pool_id(self, batch_job_pool_id):
        """
        Sets the batch_job_pool_id of this CreateBatchJobDetails.
        The `OCID`__ of the parent batch job pool.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param batch_job_pool_id: The batch_job_pool_id of this CreateBatchJobDetails.
        :type: str
        """
        self._batch_job_pool_id = batch_job_pool_id

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateBatchJobDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        If not specified or provided as null or empty string, it will be generated as \"<resourceType><timeCreated>\", where timeCreated corresponds with the resource creation time in ISO 8601 basic format, i.e. omitting separating punctuation, at second-level precision and no UTC offset. Example: batchjob20250914115623.


        :return: The display_name of this CreateBatchJobDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateBatchJobDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        If not specified or provided as null or empty string, it will be generated as \"<resourceType><timeCreated>\", where timeCreated corresponds with the resource creation time in ISO 8601 basic format, i.e. omitting separating punctuation, at second-level precision and no UTC offset. Example: batchjob20250914115623.


        :param display_name: The display_name of this CreateBatchJobDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this CreateBatchJobDetails.
        An optional description that provides additional context next to the displayName.


        :return: The description of this CreateBatchJobDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateBatchJobDetails.
        An optional description that provides additional context next to the displayName.


        :param description: The description of this CreateBatchJobDetails.
        :type: str
        """
        self._description = description

    @property
    def environment_variables(self):
        """
        Gets the environment_variables of this CreateBatchJobDetails.
        An environment variables to use for the job's tasks (can be overridden by task's environment variables).


        :return: The environment_variables of this CreateBatchJobDetails.
        :rtype: list[oci.batch.models.EnvironmentVariable]
        """
        return self._environment_variables

    @environment_variables.setter
    def environment_variables(self, environment_variables):
        """
        Sets the environment_variables of this CreateBatchJobDetails.
        An environment variables to use for the job's tasks (can be overridden by task's environment variables).


        :param environment_variables: The environment_variables of this CreateBatchJobDetails.
        :type: list[oci.batch.models.EnvironmentVariable]
        """
        self._environment_variables = environment_variables

    @property
    def tasks(self):
        """
        **[Required]** Gets the tasks of this CreateBatchJobDetails.
        A list of tasks to be executed within this job.
        Maximum number of tasks a job can have in total, across all nested levels, is 1000.


        :return: The tasks of this CreateBatchJobDetails.
        :rtype: list[oci.batch.models.CreateBatchTaskDetails]
        """
        return self._tasks

    @tasks.setter
    def tasks(self, tasks):
        """
        Sets the tasks of this CreateBatchJobDetails.
        A list of tasks to be executed within this job.
        Maximum number of tasks a job can have in total, across all nested levels, is 1000.


        :param tasks: The tasks of this CreateBatchJobDetails.
        :type: list[oci.batch.models.CreateBatchTaskDetails]
        """
        self._tasks = tasks

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateBatchJobDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateBatchJobDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateBatchJobDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateBatchJobDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateBatchJobDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateBatchJobDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateBatchJobDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateBatchJobDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
