# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20251031


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class JobPriorityConfiguration(object):
    """
    Job priority configuration to instruct the service on how to use priority tags.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new JobPriorityConfiguration object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param tag_namespace:
            The value to assign to the tag_namespace property of this JobPriorityConfiguration.
        :type tag_namespace: str

        :param tag_key:
            The value to assign to the tag_key property of this JobPriorityConfiguration.
        :type tag_key: str

        :param weight:
            The value to assign to the weight property of this JobPriorityConfiguration.
        :type weight: int

        :param values:
            The value to assign to the values property of this JobPriorityConfiguration.
        :type values: dict(str, int)

        """
        self.swagger_types = {
            'tag_namespace': 'str',
            'tag_key': 'str',
            'weight': 'int',
            'values': 'dict(str, int)'
        }
        self.attribute_map = {
            'tag_namespace': 'tagNamespace',
            'tag_key': 'tagKey',
            'weight': 'weight',
            'values': 'values'
        }
        self._tag_namespace = None
        self._tag_key = None
        self._weight = None
        self._values = None

    @property
    def tag_namespace(self):
        """
        **[Required]** Gets the tag_namespace of this JobPriorityConfiguration.
        Name of the corresponding tag namespace.


        :return: The tag_namespace of this JobPriorityConfiguration.
        :rtype: str
        """
        return self._tag_namespace

    @tag_namespace.setter
    def tag_namespace(self, tag_namespace):
        """
        Sets the tag_namespace of this JobPriorityConfiguration.
        Name of the corresponding tag namespace.


        :param tag_namespace: The tag_namespace of this JobPriorityConfiguration.
        :type: str
        """
        self._tag_namespace = tag_namespace

    @property
    def tag_key(self):
        """
        **[Required]** Gets the tag_key of this JobPriorityConfiguration.
        Name of the tag key.


        :return: The tag_key of this JobPriorityConfiguration.
        :rtype: str
        """
        return self._tag_key

    @tag_key.setter
    def tag_key(self, tag_key):
        """
        Sets the tag_key of this JobPriorityConfiguration.
        Name of the tag key.


        :param tag_key: The tag_key of this JobPriorityConfiguration.
        :type: str
        """
        self._tag_key = tag_key

    @property
    def weight(self):
        """
        **[Required]** Gets the weight of this JobPriorityConfiguration.
        Weight associated with the tag key. Percentage point is the unit of measurement.


        :return: The weight of this JobPriorityConfiguration.
        :rtype: int
        """
        return self._weight

    @weight.setter
    def weight(self, weight):
        """
        Sets the weight of this JobPriorityConfiguration.
        Weight associated with the tag key. Percentage point is the unit of measurement.


        :param weight: The weight of this JobPriorityConfiguration.
        :type: int
        """
        self._weight = weight

    @property
    def values(self):
        """
        **[Required]** Gets the values of this JobPriorityConfiguration.
        Mapping of tag value to its priority.


        :return: The values of this JobPriorityConfiguration.
        :rtype: dict(str, int)
        """
        return self._values

    @values.setter
    def values(self, values):
        """
        Sets the values of this JobPriorityConfiguration.
        Mapping of tag value to its priority.


        :param values: The values of this JobPriorityConfiguration.
        :type: dict(str, int)
        """
        self._values = values

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
