# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20251031


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ShapeOcpuOptions(object):
    """
    For a flexible shape, the number of OCPUs available for container instances that use this shape.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ShapeOcpuOptions object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param max_ocpus:
            The value to assign to the max_ocpus property of this ShapeOcpuOptions.
        :type max_ocpus: float

        :param min_ocpus:
            The value to assign to the min_ocpus property of this ShapeOcpuOptions.
        :type min_ocpus: float

        """
        self.swagger_types = {
            'max_ocpus': 'float',
            'min_ocpus': 'float'
        }
        self.attribute_map = {
            'max_ocpus': 'maxOcpus',
            'min_ocpus': 'minOcpus'
        }
        self._max_ocpus = None
        self._min_ocpus = None

    @property
    def max_ocpus(self):
        """
        **[Required]** Gets the max_ocpus of this ShapeOcpuOptions.
        The maximum number of OCPUs.


        :return: The max_ocpus of this ShapeOcpuOptions.
        :rtype: float
        """
        return self._max_ocpus

    @max_ocpus.setter
    def max_ocpus(self, max_ocpus):
        """
        Sets the max_ocpus of this ShapeOcpuOptions.
        The maximum number of OCPUs.


        :param max_ocpus: The max_ocpus of this ShapeOcpuOptions.
        :type: float
        """
        self._max_ocpus = max_ocpus

    @property
    def min_ocpus(self):
        """
        **[Required]** Gets the min_ocpus of this ShapeOcpuOptions.
        The minimum number of OCPUs.


        :return: The min_ocpus of this ShapeOcpuOptions.
        :rtype: float
        """
        return self._min_ocpus

    @min_ocpus.setter
    def min_ocpus(self, min_ocpus):
        """
        Sets the min_ocpus of this ShapeOcpuOptions.
        The minimum number of OCPUs.


        :param min_ocpus: The min_ocpus of this ShapeOcpuOptions.
        :type: float
        """
        self._min_ocpus = min_ocpus

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
