# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateResourcePrincipalConfigurationDetails(object):
    """
    Details of updating the resource principal configuration for the cluster.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateResourcePrincipalConfigurationDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this UpdateResourcePrincipalConfigurationDetails.
        :type display_name: str

        :param session_token_life_span_duration_in_hours:
            The value to assign to the session_token_life_span_duration_in_hours property of this UpdateResourcePrincipalConfigurationDetails.
        :type session_token_life_span_duration_in_hours: int

        """
        self.swagger_types = {
            'display_name': 'str',
            'session_token_life_span_duration_in_hours': 'int'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'session_token_life_span_duration_in_hours': 'sessionTokenLifeSpanDurationInHours'
        }
        self._display_name = None
        self._session_token_life_span_duration_in_hours = None

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdateResourcePrincipalConfigurationDetails.
        A user-friendly name. Only ASCII alphanumeric characters with no spaces allowed. The name does not have to be unique, and it may be changed. Avoid entering confidential information.


        :return: The display_name of this UpdateResourcePrincipalConfigurationDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdateResourcePrincipalConfigurationDetails.
        A user-friendly name. Only ASCII alphanumeric characters with no spaces allowed. The name does not have to be unique, and it may be changed. Avoid entering confidential information.


        :param display_name: The display_name of this UpdateResourcePrincipalConfigurationDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def session_token_life_span_duration_in_hours(self):
        """
        Gets the session_token_life_span_duration_in_hours of this UpdateResourcePrincipalConfigurationDetails.
        Life span in hours for the resource principal session token.


        :return: The session_token_life_span_duration_in_hours of this UpdateResourcePrincipalConfigurationDetails.
        :rtype: int
        """
        return self._session_token_life_span_duration_in_hours

    @session_token_life_span_duration_in_hours.setter
    def session_token_life_span_duration_in_hours(self, session_token_life_span_duration_in_hours):
        """
        Sets the session_token_life_span_duration_in_hours of this UpdateResourcePrincipalConfigurationDetails.
        Life span in hours for the resource principal session token.


        :param session_token_life_span_duration_in_hours: The session_token_life_span_duration_in_hours of this UpdateResourcePrincipalConfigurationDetails.
        :type: int
        """
        self._session_token_life_span_duration_in_hours = session_token_life_span_duration_in_hours

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
