# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181231

from .update_item_details import UpdateItemDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateContactItemDetails(UpdateItemDetails):
    """
    Details for updating the support request activity.
    """

    #: A constant which can be used with the activity_type property of a UpdateContactItemDetails.
    #: This constant has a value of "NOTES"
    ACTIVITY_TYPE_NOTES = "NOTES"

    #: A constant which can be used with the activity_type property of a UpdateContactItemDetails.
    #: This constant has a value of "PROBLEM_DESCRIPTION"
    ACTIVITY_TYPE_PROBLEM_DESCRIPTION = "PROBLEM_DESCRIPTION"

    #: A constant which can be used with the activity_type property of a UpdateContactItemDetails.
    #: This constant has a value of "UPDATE"
    ACTIVITY_TYPE_UPDATE = "UPDATE"

    #: A constant which can be used with the activity_type property of a UpdateContactItemDetails.
    #: This constant has a value of "CLOSE"
    ACTIVITY_TYPE_CLOSE = "CLOSE"

    #: A constant which can be used with the activity_type property of a UpdateContactItemDetails.
    #: This constant has a value of "REOPEN"
    ACTIVITY_TYPE_REOPEN = "REOPEN"

    #: A constant which can be used with the activity_type property of a UpdateContactItemDetails.
    #: This constant has a value of "ADD_CONTACT"
    ACTIVITY_TYPE_ADD_CONTACT = "ADD_CONTACT"

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateContactItemDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.cims.models.UpdateContactItemDetails.type` attribute
        of this class is ``contact`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this UpdateContactItemDetails.
        :type type: str

        :param contact:
            The value to assign to the contact property of this UpdateContactItemDetails.
        :type contact: str

        :param activity_type:
            The value to assign to the activity_type property of this UpdateContactItemDetails.
            Allowed values for this property are: "NOTES", "PROBLEM_DESCRIPTION", "UPDATE", "CLOSE", "REOPEN", "ADD_CONTACT"
        :type activity_type: str

        """
        self.swagger_types = {
            'type': 'str',
            'contact': 'str',
            'activity_type': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'contact': 'contact',
            'activity_type': 'activityType'
        }
        self._type = None
        self._contact = None
        self._activity_type = None
        self._type = 'contact'

    @property
    def contact(self):
        """
        Gets the contact of this UpdateContactItemDetails.
        Email id of the additional contact to be added to the support request.


        :return: The contact of this UpdateContactItemDetails.
        :rtype: str
        """
        return self._contact

    @contact.setter
    def contact(self, contact):
        """
        Sets the contact of this UpdateContactItemDetails.
        Email id of the additional contact to be added to the support request.


        :param contact: The contact of this UpdateContactItemDetails.
        :type: str
        """
        self._contact = contact

    @property
    def activity_type(self):
        """
        Gets the activity_type of this UpdateContactItemDetails.
        The type of activity occurring.
        `NOTES` is the activity associated to attachments.
        `PROBLEM_DESCRIPTION` is the activity associated to customer problem description.
        `UPDATE` is the activity associated to adding comments.
        `CLOSE` is the activity associated to closing the support request.
        `REOPEN` is the activity associated to reopening the support request.
        `ADD_CONTACT` is the activity associated to adding additional contact to the support request.

        Allowed values for this property are: "NOTES", "PROBLEM_DESCRIPTION", "UPDATE", "CLOSE", "REOPEN", "ADD_CONTACT"


        :return: The activity_type of this UpdateContactItemDetails.
        :rtype: str
        """
        return self._activity_type

    @activity_type.setter
    def activity_type(self, activity_type):
        """
        Sets the activity_type of this UpdateContactItemDetails.
        The type of activity occurring.
        `NOTES` is the activity associated to attachments.
        `PROBLEM_DESCRIPTION` is the activity associated to customer problem description.
        `UPDATE` is the activity associated to adding comments.
        `CLOSE` is the activity associated to closing the support request.
        `REOPEN` is the activity associated to reopening the support request.
        `ADD_CONTACT` is the activity associated to adding additional contact to the support request.


        :param activity_type: The activity_type of this UpdateContactItemDetails.
        :type: str
        """
        allowed_values = ["NOTES", "PROBLEM_DESCRIPTION", "UPDATE", "CLOSE", "REOPEN", "ADD_CONTACT"]
        if not value_allowed_none_or_none_sentinel(activity_type, allowed_values):
            raise ValueError(
                f"Invalid value for `activity_type`, must be None or one of {allowed_values}"
            )
        self._activity_type = activity_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
