# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200131


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RuleType(object):
    """
    The detector rule types.
    """

    #: A constant which can be used with the key property of a RuleType.
    #: This constant has a value of "CATEGORY"
    KEY_CATEGORY = "CATEGORY"

    def __init__(self, **kwargs):
        """
        Initializes a new RuleType object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param key:
            The value to assign to the key property of this RuleType.
            Allowed values for this property are: "CATEGORY", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type key: str

        :param value:
            The value to assign to the value property of this RuleType.
        :type value: list[str]

        """
        self.swagger_types = {
            'key': 'str',
            'value': 'list[str]'
        }
        self.attribute_map = {
            'key': 'key',
            'value': 'value'
        }
        self._key = None
        self._value = None

    @property
    def key(self):
        """
        **[Required]** Gets the key of this RuleType.
        The unique identifier of the detector rule type

        Allowed values for this property are: "CATEGORY", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The key of this RuleType.
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """
        Sets the key of this RuleType.
        The unique identifier of the detector rule type


        :param key: The key of this RuleType.
        :type: str
        """
        allowed_values = ["CATEGORY"]
        if not value_allowed_none_or_none_sentinel(key, allowed_values):
            key = 'UNKNOWN_ENUM_VALUE'
        self._key = key

    @property
    def value(self):
        """
        **[Required]** Gets the value of this RuleType.
        Detector rule type value


        :return: The value of this RuleType.
        :rtype: list[str]
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this RuleType.
        Detector rule type value


        :param value: The value of this RuleType.
        :type: list[str]
        """
        self._value = value

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
