# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180530


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class InstanceAgentPlugin(object):
    """
    An Oracle Cloud Agent plugin.
    """

    #: A constant which can be used with the status property of a InstanceAgentPlugin.
    #: This constant has a value of "RUNNING"
    STATUS_RUNNING = "RUNNING"

    #: A constant which can be used with the status property of a InstanceAgentPlugin.
    #: This constant has a value of "STOPPED"
    STATUS_STOPPED = "STOPPED"

    #: A constant which can be used with the status property of a InstanceAgentPlugin.
    #: This constant has a value of "NOT_SUPPORTED"
    STATUS_NOT_SUPPORTED = "NOT_SUPPORTED"

    #: A constant which can be used with the status property of a InstanceAgentPlugin.
    #: This constant has a value of "INVALID"
    STATUS_INVALID = "INVALID"

    def __init__(self, **kwargs):
        """
        Initializes a new InstanceAgentPlugin object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this InstanceAgentPlugin.
        :type name: str

        :param status:
            The value to assign to the status property of this InstanceAgentPlugin.
            Allowed values for this property are: "RUNNING", "STOPPED", "NOT_SUPPORTED", "INVALID", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type status: str

        :param time_last_updated_utc:
            The value to assign to the time_last_updated_utc property of this InstanceAgentPlugin.
        :type time_last_updated_utc: datetime

        :param message:
            The value to assign to the message property of this InstanceAgentPlugin.
        :type message: str

        """
        self.swagger_types = {
            'name': 'str',
            'status': 'str',
            'time_last_updated_utc': 'datetime',
            'message': 'str'
        }
        self.attribute_map = {
            'name': 'name',
            'status': 'status',
            'time_last_updated_utc': 'timeLastUpdatedUtc',
            'message': 'message'
        }
        self._name = None
        self._status = None
        self._time_last_updated_utc = None
        self._message = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this InstanceAgentPlugin.
        The plugin name.


        :return: The name of this InstanceAgentPlugin.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this InstanceAgentPlugin.
        The plugin name.


        :param name: The name of this InstanceAgentPlugin.
        :type: str
        """
        self._name = name

    @property
    def status(self):
        """
        **[Required]** Gets the status of this InstanceAgentPlugin.
        The plugin status.

        These are the available statuses:
        * `RUNNING` - The plugin is running.
        * `STOPPED` - The plugin is stopped.
        * `NOT_SUPPORTED` - The plugin is not supported on this platform.
        * `INVALID` - The plugin status is not recognizable by the service.

        To determine whether the plugin is enabled, use the
        :func:`get_instance` operation in the Core
        Services API. To enable or disable the plugin, use the
        :func:`update_instance` operation
        in the Core Services API.

        Allowed values for this property are: "RUNNING", "STOPPED", "NOT_SUPPORTED", "INVALID", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The status of this InstanceAgentPlugin.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this InstanceAgentPlugin.
        The plugin status.

        These are the available statuses:
        * `RUNNING` - The plugin is running.
        * `STOPPED` - The plugin is stopped.
        * `NOT_SUPPORTED` - The plugin is not supported on this platform.
        * `INVALID` - The plugin status is not recognizable by the service.

        To determine whether the plugin is enabled, use the
        :func:`get_instance` operation in the Core
        Services API. To enable or disable the plugin, use the
        :func:`update_instance` operation
        in the Core Services API.


        :param status: The status of this InstanceAgentPlugin.
        :type: str
        """
        allowed_values = ["RUNNING", "STOPPED", "NOT_SUPPORTED", "INVALID"]
        if not value_allowed_none_or_none_sentinel(status, allowed_values):
            status = 'UNKNOWN_ENUM_VALUE'
        self._status = status

    @property
    def time_last_updated_utc(self):
        """
        **[Required]** Gets the time_last_updated_utc of this InstanceAgentPlugin.
        The last updated time of the plugin, in UTC.


        :return: The time_last_updated_utc of this InstanceAgentPlugin.
        :rtype: datetime
        """
        return self._time_last_updated_utc

    @time_last_updated_utc.setter
    def time_last_updated_utc(self, time_last_updated_utc):
        """
        Sets the time_last_updated_utc of this InstanceAgentPlugin.
        The last updated time of the plugin, in UTC.


        :param time_last_updated_utc: The time_last_updated_utc of this InstanceAgentPlugin.
        :type: datetime
        """
        self._time_last_updated_utc = time_last_updated_utc

    @property
    def message(self):
        """
        Gets the message of this InstanceAgentPlugin.
        An optional message from the plugin.


        :return: The message of this InstanceAgentPlugin.
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """
        Sets the message of this InstanceAgentPlugin.
        An optional message from the plugin.


        :param message: The message of this InstanceAgentPlugin.
        :type: str
        """
        self._message = message

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
