# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class FirmwareBundleTransitions(object):
    """
    A map of firmware bundle upgrades/downgrades validated by OCI.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new FirmwareBundleTransitions object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param upgrades:
            The value to assign to the upgrades property of this FirmwareBundleTransitions.
        :type upgrades: list[str]

        :param downgrades:
            The value to assign to the downgrades property of this FirmwareBundleTransitions.
        :type downgrades: list[str]

        """
        self.swagger_types = {
            'upgrades': 'list[str]',
            'downgrades': 'list[str]'
        }
        self.attribute_map = {
            'upgrades': 'upgrades',
            'downgrades': 'downgrades'
        }
        self._upgrades = None
        self._downgrades = None

    @property
    def upgrades(self):
        """
        Gets the upgrades of this FirmwareBundleTransitions.
        An array of `OCIDs`__ of validated firmware bundle upgrades.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The upgrades of this FirmwareBundleTransitions.
        :rtype: list[str]
        """
        return self._upgrades

    @upgrades.setter
    def upgrades(self, upgrades):
        """
        Sets the upgrades of this FirmwareBundleTransitions.
        An array of `OCIDs`__ of validated firmware bundle upgrades.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param upgrades: The upgrades of this FirmwareBundleTransitions.
        :type: list[str]
        """
        self._upgrades = upgrades

    @property
    def downgrades(self):
        """
        Gets the downgrades of this FirmwareBundleTransitions.
        An array of `OCIDs`__ of validated firmware bundle downgrades.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The downgrades of this FirmwareBundleTransitions.
        :rtype: list[str]
        """
        return self._downgrades

    @downgrades.setter
    def downgrades(self, downgrades):
        """
        Sets the downgrades of this FirmwareBundleTransitions.
        An array of `OCIDs`__ of validated firmware bundle downgrades.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param downgrades: The downgrades of this FirmwareBundleTransitions.
        :type: list[str]
        """
        self._downgrades = downgrades

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
