# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class InstancePoolPreTerminationActionHandleTimeoutDetails(object):
    """
    Options to handle timeout for pre-termination action.
    """

    #: A constant which can be used with the preserve_block_volume_mode property of a InstancePoolPreTerminationActionHandleTimeoutDetails.
    #: This constant has a value of "PRESERVE_ALWAYS"
    PRESERVE_BLOCK_VOLUME_MODE_PRESERVE_ALWAYS = "PRESERVE_ALWAYS"

    #: A constant which can be used with the preserve_block_volume_mode property of a InstancePoolPreTerminationActionHandleTimeoutDetails.
    #: This constant has a value of "PRESERVE_ON_TIMEOUT"
    PRESERVE_BLOCK_VOLUME_MODE_PRESERVE_ON_TIMEOUT = "PRESERVE_ON_TIMEOUT"

    #: A constant which can be used with the preserve_block_volume_mode property of a InstancePoolPreTerminationActionHandleTimeoutDetails.
    #: This constant has a value of "DELETE_ALWAYS"
    PRESERVE_BLOCK_VOLUME_MODE_DELETE_ALWAYS = "DELETE_ALWAYS"

    #: A constant which can be used with the preserve_boot_volume_mode property of a InstancePoolPreTerminationActionHandleTimeoutDetails.
    #: This constant has a value of "PRESERVE_ALWAYS"
    PRESERVE_BOOT_VOLUME_MODE_PRESERVE_ALWAYS = "PRESERVE_ALWAYS"

    #: A constant which can be used with the preserve_boot_volume_mode property of a InstancePoolPreTerminationActionHandleTimeoutDetails.
    #: This constant has a value of "PRESERVE_ON_TIMEOUT"
    PRESERVE_BOOT_VOLUME_MODE_PRESERVE_ON_TIMEOUT = "PRESERVE_ON_TIMEOUT"

    #: A constant which can be used with the preserve_boot_volume_mode property of a InstancePoolPreTerminationActionHandleTimeoutDetails.
    #: This constant has a value of "DELETE_ALWAYS"
    PRESERVE_BOOT_VOLUME_MODE_DELETE_ALWAYS = "DELETE_ALWAYS"

    def __init__(self, **kwargs):
        """
        Initializes a new InstancePoolPreTerminationActionHandleTimeoutDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param preserve_block_volume_mode:
            The value to assign to the preserve_block_volume_mode property of this InstancePoolPreTerminationActionHandleTimeoutDetails.
            Allowed values for this property are: "PRESERVE_ALWAYS", "PRESERVE_ON_TIMEOUT", "DELETE_ALWAYS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type preserve_block_volume_mode: str

        :param preserve_boot_volume_mode:
            The value to assign to the preserve_boot_volume_mode property of this InstancePoolPreTerminationActionHandleTimeoutDetails.
            Allowed values for this property are: "PRESERVE_ALWAYS", "PRESERVE_ON_TIMEOUT", "DELETE_ALWAYS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type preserve_boot_volume_mode: str

        """
        self.swagger_types = {
            'preserve_block_volume_mode': 'str',
            'preserve_boot_volume_mode': 'str'
        }
        self.attribute_map = {
            'preserve_block_volume_mode': 'preserveBlockVolumeMode',
            'preserve_boot_volume_mode': 'preserveBootVolumeMode'
        }
        self._preserve_block_volume_mode = None
        self._preserve_boot_volume_mode = None

    @property
    def preserve_block_volume_mode(self):
        """
        **[Required]** Gets the preserve_block_volume_mode of this InstancePoolPreTerminationActionHandleTimeoutDetails.
        Whether the block volume should be preserved after termination.

        Allowed values for this property are: "PRESERVE_ALWAYS", "PRESERVE_ON_TIMEOUT", "DELETE_ALWAYS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The preserve_block_volume_mode of this InstancePoolPreTerminationActionHandleTimeoutDetails.
        :rtype: str
        """
        return self._preserve_block_volume_mode

    @preserve_block_volume_mode.setter
    def preserve_block_volume_mode(self, preserve_block_volume_mode):
        """
        Sets the preserve_block_volume_mode of this InstancePoolPreTerminationActionHandleTimeoutDetails.
        Whether the block volume should be preserved after termination.


        :param preserve_block_volume_mode: The preserve_block_volume_mode of this InstancePoolPreTerminationActionHandleTimeoutDetails.
        :type: str
        """
        allowed_values = ["PRESERVE_ALWAYS", "PRESERVE_ON_TIMEOUT", "DELETE_ALWAYS"]
        if not value_allowed_none_or_none_sentinel(preserve_block_volume_mode, allowed_values):
            preserve_block_volume_mode = 'UNKNOWN_ENUM_VALUE'
        self._preserve_block_volume_mode = preserve_block_volume_mode

    @property
    def preserve_boot_volume_mode(self):
        """
        **[Required]** Gets the preserve_boot_volume_mode of this InstancePoolPreTerminationActionHandleTimeoutDetails.
        Whether the boot volume should be preserved after termination.

        Allowed values for this property are: "PRESERVE_ALWAYS", "PRESERVE_ON_TIMEOUT", "DELETE_ALWAYS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The preserve_boot_volume_mode of this InstancePoolPreTerminationActionHandleTimeoutDetails.
        :rtype: str
        """
        return self._preserve_boot_volume_mode

    @preserve_boot_volume_mode.setter
    def preserve_boot_volume_mode(self, preserve_boot_volume_mode):
        """
        Sets the preserve_boot_volume_mode of this InstancePoolPreTerminationActionHandleTimeoutDetails.
        Whether the boot volume should be preserved after termination.


        :param preserve_boot_volume_mode: The preserve_boot_volume_mode of this InstancePoolPreTerminationActionHandleTimeoutDetails.
        :type: str
        """
        allowed_values = ["PRESERVE_ALWAYS", "PRESERVE_ON_TIMEOUT", "DELETE_ALWAYS"]
        if not value_allowed_none_or_none_sentinel(preserve_boot_volume_mode, allowed_values):
            preserve_boot_volume_mode = 'UNKNOWN_ENUM_VALUE'
        self._preserve_boot_volume_mode = preserve_boot_volume_mode

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
