# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ListIpInventoryDetails(object):
    """
    Required input parameters for retrieving IP Inventory data within the specified compartments of a region.
    """

    #: A constant which can be used with the resource_type_list property of a ListIpInventoryDetails.
    #: This constant has a value of "Resource"
    RESOURCE_TYPE_LIST_RESOURCE = "Resource"

    #: A constant which can be used with the sort_by property of a ListIpInventoryDetails.
    #: This constant has a value of "DISPLAYNAME"
    SORT_BY_DISPLAYNAME = "DISPLAYNAME"

    #: A constant which can be used with the sort_by property of a ListIpInventoryDetails.
    #: This constant has a value of "UTILIZATION"
    SORT_BY_UTILIZATION = "UTILIZATION"

    #: A constant which can be used with the sort_by property of a ListIpInventoryDetails.
    #: This constant has a value of "DNS_HOSTNAME"
    SORT_BY_DNS_HOSTNAME = "DNS_HOSTNAME"

    #: A constant which can be used with the sort_by property of a ListIpInventoryDetails.
    #: This constant has a value of "REGION"
    SORT_BY_REGION = "REGION"

    #: A constant which can be used with the sort_order property of a ListIpInventoryDetails.
    #: This constant has a value of "ASC"
    SORT_ORDER_ASC = "ASC"

    #: A constant which can be used with the sort_order property of a ListIpInventoryDetails.
    #: This constant has a value of "DESC"
    SORT_ORDER_DESC = "DESC"

    def __init__(self, **kwargs):
        """
        Initializes a new ListIpInventoryDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param region_list:
            The value to assign to the region_list property of this ListIpInventoryDetails.
        :type region_list: list[str]

        :param compartment_list:
            The value to assign to the compartment_list property of this ListIpInventoryDetails.
        :type compartment_list: list[str]

        :param override_filters:
            The value to assign to the override_filters property of this ListIpInventoryDetails.
        :type override_filters: bool

        :param utilization:
            The value to assign to the utilization property of this ListIpInventoryDetails.
        :type utilization: float

        :param overlapping_vcns_only:
            The value to assign to the overlapping_vcns_only property of this ListIpInventoryDetails.
        :type overlapping_vcns_only: bool

        :param address_type_list:
            The value to assign to the address_type_list property of this ListIpInventoryDetails.
        :type address_type_list: list[oci.core.models.AddressType]

        :param resource_type_list:
            The value to assign to the resource_type_list property of this ListIpInventoryDetails.
            Allowed values for items in this list are: "Resource"
        :type resource_type_list: list[str]

        :param search_keyword:
            The value to assign to the search_keyword property of this ListIpInventoryDetails.
        :type search_keyword: str

        :param sort_by:
            The value to assign to the sort_by property of this ListIpInventoryDetails.
            Allowed values for this property are: "DISPLAYNAME", "UTILIZATION", "DNS_HOSTNAME", "REGION"
        :type sort_by: str

        :param sort_order:
            The value to assign to the sort_order property of this ListIpInventoryDetails.
            Allowed values for this property are: "ASC", "DESC"
        :type sort_order: str

        :param pagination_offset:
            The value to assign to the pagination_offset property of this ListIpInventoryDetails.
        :type pagination_offset: int

        :param pagination_limit:
            The value to assign to the pagination_limit property of this ListIpInventoryDetails.
        :type pagination_limit: int

        """
        self.swagger_types = {
            'region_list': 'list[str]',
            'compartment_list': 'list[str]',
            'override_filters': 'bool',
            'utilization': 'float',
            'overlapping_vcns_only': 'bool',
            'address_type_list': 'list[AddressType]',
            'resource_type_list': 'list[str]',
            'search_keyword': 'str',
            'sort_by': 'str',
            'sort_order': 'str',
            'pagination_offset': 'int',
            'pagination_limit': 'int'
        }
        self.attribute_map = {
            'region_list': 'regionList',
            'compartment_list': 'compartmentList',
            'override_filters': 'overrideFilters',
            'utilization': 'utilization',
            'overlapping_vcns_only': 'overlappingVcnsOnly',
            'address_type_list': 'addressTypeList',
            'resource_type_list': 'resourceTypeList',
            'search_keyword': 'searchKeyword',
            'sort_by': 'sortBy',
            'sort_order': 'sortOrder',
            'pagination_offset': 'paginationOffset',
            'pagination_limit': 'paginationLimit'
        }
        self._region_list = None
        self._compartment_list = None
        self._override_filters = None
        self._utilization = None
        self._overlapping_vcns_only = None
        self._address_type_list = None
        self._resource_type_list = None
        self._search_keyword = None
        self._sort_by = None
        self._sort_order = None
        self._pagination_offset = None
        self._pagination_limit = None

    @property
    def region_list(self):
        """
        **[Required]** Gets the region_list of this ListIpInventoryDetails.
        Lists the selected regions.


        :return: The region_list of this ListIpInventoryDetails.
        :rtype: list[str]
        """
        return self._region_list

    @region_list.setter
    def region_list(self, region_list):
        """
        Sets the region_list of this ListIpInventoryDetails.
        Lists the selected regions.


        :param region_list: The region_list of this ListIpInventoryDetails.
        :type: list[str]
        """
        self._region_list = region_list

    @property
    def compartment_list(self):
        """
        **[Required]** Gets the compartment_list of this ListIpInventoryDetails.
        List the `OCID`__ of the compartments.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_list of this ListIpInventoryDetails.
        :rtype: list[str]
        """
        return self._compartment_list

    @compartment_list.setter
    def compartment_list(self, compartment_list):
        """
        Sets the compartment_list of this ListIpInventoryDetails.
        List the `OCID`__ of the compartments.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_list: The compartment_list of this ListIpInventoryDetails.
        :type: list[str]
        """
        self._compartment_list = compartment_list

    @property
    def override_filters(self):
        """
        Gets the override_filters of this ListIpInventoryDetails.
        List of selected filters.


        :return: The override_filters of this ListIpInventoryDetails.
        :rtype: bool
        """
        return self._override_filters

    @override_filters.setter
    def override_filters(self, override_filters):
        """
        Sets the override_filters of this ListIpInventoryDetails.
        List of selected filters.


        :param override_filters: The override_filters of this ListIpInventoryDetails.
        :type: bool
        """
        self._override_filters = override_filters

    @property
    def utilization(self):
        """
        Gets the utilization of this ListIpInventoryDetails.
        The CIDR utilization of a VCN.


        :return: The utilization of this ListIpInventoryDetails.
        :rtype: float
        """
        return self._utilization

    @utilization.setter
    def utilization(self, utilization):
        """
        Sets the utilization of this ListIpInventoryDetails.
        The CIDR utilization of a VCN.


        :param utilization: The utilization of this ListIpInventoryDetails.
        :type: float
        """
        self._utilization = utilization

    @property
    def overlapping_vcns_only(self):
        """
        Gets the overlapping_vcns_only of this ListIpInventoryDetails.
        List of overlapping VCNs.


        :return: The overlapping_vcns_only of this ListIpInventoryDetails.
        :rtype: bool
        """
        return self._overlapping_vcns_only

    @overlapping_vcns_only.setter
    def overlapping_vcns_only(self, overlapping_vcns_only):
        """
        Sets the overlapping_vcns_only of this ListIpInventoryDetails.
        List of overlapping VCNs.


        :param overlapping_vcns_only: The overlapping_vcns_only of this ListIpInventoryDetails.
        :type: bool
        """
        self._overlapping_vcns_only = overlapping_vcns_only

    @property
    def address_type_list(self):
        """
        Gets the address_type_list of this ListIpInventoryDetails.
        List of IP address types used.


        :return: The address_type_list of this ListIpInventoryDetails.
        :rtype: list[oci.core.models.AddressType]
        """
        return self._address_type_list

    @address_type_list.setter
    def address_type_list(self, address_type_list):
        """
        Sets the address_type_list of this ListIpInventoryDetails.
        List of IP address types used.


        :param address_type_list: The address_type_list of this ListIpInventoryDetails.
        :type: list[oci.core.models.AddressType]
        """
        self._address_type_list = address_type_list

    @property
    def resource_type_list(self):
        """
        Gets the resource_type_list of this ListIpInventoryDetails.
        List of VCN resource types.

        Allowed values for items in this list are: "Resource"


        :return: The resource_type_list of this ListIpInventoryDetails.
        :rtype: list[str]
        """
        return self._resource_type_list

    @resource_type_list.setter
    def resource_type_list(self, resource_type_list):
        """
        Sets the resource_type_list of this ListIpInventoryDetails.
        List of VCN resource types.


        :param resource_type_list: The resource_type_list of this ListIpInventoryDetails.
        :type: list[str]
        """
        allowed_values = ["Resource"]

        if resource_type_list and resource_type_list is not NONE_SENTINEL:
            for value in resource_type_list:
                if not value_allowed_none_or_none_sentinel(value, allowed_values):
                    raise ValueError(
                        f"Invalid value for `resource_type_list`, must be None or one of {allowed_values}"
                    )
        self._resource_type_list = resource_type_list

    @property
    def search_keyword(self):
        """
        Gets the search_keyword of this ListIpInventoryDetails.
        Filters the results for the specified string.


        :return: The search_keyword of this ListIpInventoryDetails.
        :rtype: str
        """
        return self._search_keyword

    @search_keyword.setter
    def search_keyword(self, search_keyword):
        """
        Sets the search_keyword of this ListIpInventoryDetails.
        Filters the results for the specified string.


        :param search_keyword: The search_keyword of this ListIpInventoryDetails.
        :type: str
        """
        self._search_keyword = search_keyword

    @property
    def sort_by(self):
        """
        Gets the sort_by of this ListIpInventoryDetails.
        Provide the sort order (`sortOrder`) to sort the fields such as TIMECREATED in descending or descending order, and DISPLAYNAME in case sensitive.

        **Note:** For some \"List\" operations (for example, `ListInstances`), sort resources by an availability domain when the resources belong to a single availability domain.
        If you sort the \"List\" operations without specifying
        an availability domain, the resources are grouped by availability domains and then sorted.

        Allowed values for this property are: "DISPLAYNAME", "UTILIZATION", "DNS_HOSTNAME", "REGION"


        :return: The sort_by of this ListIpInventoryDetails.
        :rtype: str
        """
        return self._sort_by

    @sort_by.setter
    def sort_by(self, sort_by):
        """
        Sets the sort_by of this ListIpInventoryDetails.
        Provide the sort order (`sortOrder`) to sort the fields such as TIMECREATED in descending or descending order, and DISPLAYNAME in case sensitive.

        **Note:** For some \"List\" operations (for example, `ListInstances`), sort resources by an availability domain when the resources belong to a single availability domain.
        If you sort the \"List\" operations without specifying
        an availability domain, the resources are grouped by availability domains and then sorted.


        :param sort_by: The sort_by of this ListIpInventoryDetails.
        :type: str
        """
        allowed_values = ["DISPLAYNAME", "UTILIZATION", "DNS_HOSTNAME", "REGION"]
        if not value_allowed_none_or_none_sentinel(sort_by, allowed_values):
            raise ValueError(
                f"Invalid value for `sort_by`, must be None or one of {allowed_values}"
            )
        self._sort_by = sort_by

    @property
    def sort_order(self):
        """
        Gets the sort_order of this ListIpInventoryDetails.
        Specifies the sort order to use. Select either ascending (`ASC`) or descending (`DESC`) order. The DISPLAYNAME sort order
        is case sensitive.

        Allowed values for this property are: "ASC", "DESC"


        :return: The sort_order of this ListIpInventoryDetails.
        :rtype: str
        """
        return self._sort_order

    @sort_order.setter
    def sort_order(self, sort_order):
        """
        Sets the sort_order of this ListIpInventoryDetails.
        Specifies the sort order to use. Select either ascending (`ASC`) or descending (`DESC`) order. The DISPLAYNAME sort order
        is case sensitive.


        :param sort_order: The sort_order of this ListIpInventoryDetails.
        :type: str
        """
        allowed_values = ["ASC", "DESC"]
        if not value_allowed_none_or_none_sentinel(sort_order, allowed_values):
            raise ValueError(
                f"Invalid value for `sort_order`, must be None or one of {allowed_values}"
            )
        self._sort_order = sort_order

    @property
    def pagination_offset(self):
        """
        Gets the pagination_offset of this ListIpInventoryDetails.
        Most List operations paginate results. Results are paginated for the ListInstances operations. When you call a paginated List operation, the response indicates more pages of results by including the opc-next-page header.
        For more information, see `List Pagination`__.

        __ https://docs.cloud.oracle.com/iaas/Content/API/Concepts/usingapi.htm#nine


        :return: The pagination_offset of this ListIpInventoryDetails.
        :rtype: int
        """
        return self._pagination_offset

    @pagination_offset.setter
    def pagination_offset(self, pagination_offset):
        """
        Sets the pagination_offset of this ListIpInventoryDetails.
        Most List operations paginate results. Results are paginated for the ListInstances operations. When you call a paginated List operation, the response indicates more pages of results by including the opc-next-page header.
        For more information, see `List Pagination`__.

        __ https://docs.cloud.oracle.com/iaas/Content/API/Concepts/usingapi.htm#nine


        :param pagination_offset: The pagination_offset of this ListIpInventoryDetails.
        :type: int
        """
        self._pagination_offset = pagination_offset

    @property
    def pagination_limit(self):
        """
        Gets the pagination_limit of this ListIpInventoryDetails.
        Specifies the maximum number of results displayed per page for a paginated \"List\" call. For more information, see `List Pagination`__.
        Example: `50`

        __ https://docs.cloud.oracle.com/iaas/Content/API/Concepts/usingapi.htm#nine


        :return: The pagination_limit of this ListIpInventoryDetails.
        :rtype: int
        """
        return self._pagination_limit

    @pagination_limit.setter
    def pagination_limit(self, pagination_limit):
        """
        Sets the pagination_limit of this ListIpInventoryDetails.
        Specifies the maximum number of results displayed per page for a paginated \"List\" call. For more information, see `List Pagination`__.
        Example: `50`

        __ https://docs.cloud.oracle.com/iaas/Content/API/Concepts/usingapi.htm#nine


        :param pagination_limit: The pagination_limit of this ListIpInventoryDetails.
        :type: int
        """
        self._pagination_limit = pagination_limit

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
