# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MemoryFabricPreferencesDescriptor(object):
    """
    The preference object specified by customer. Contains customerDesiredFirmwareBundleId, fabricRecycleLevel.
    """

    #: A constant which can be used with the fabric_recycle_level property of a MemoryFabricPreferencesDescriptor.
    #: This constant has a value of "FULL_RECYCLE"
    FABRIC_RECYCLE_LEVEL_FULL_RECYCLE = "FULL_RECYCLE"

    #: A constant which can be used with the fabric_recycle_level property of a MemoryFabricPreferencesDescriptor.
    #: This constant has a value of "SKIP_RECYCLE"
    FABRIC_RECYCLE_LEVEL_SKIP_RECYCLE = "SKIP_RECYCLE"

    #: A constant which can be used with the fabric_recycle_level property of a MemoryFabricPreferencesDescriptor.
    #: This constant has a value of "OPPORTUNISTIC_FULL_RECYCLE"
    FABRIC_RECYCLE_LEVEL_OPPORTUNISTIC_FULL_RECYCLE = "OPPORTUNISTIC_FULL_RECYCLE"

    def __init__(self, **kwargs):
        """
        Initializes a new MemoryFabricPreferencesDescriptor object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param customer_desired_firmware_bundle_id:
            The value to assign to the customer_desired_firmware_bundle_id property of this MemoryFabricPreferencesDescriptor.
        :type customer_desired_firmware_bundle_id: str

        :param fabric_recycle_level:
            The value to assign to the fabric_recycle_level property of this MemoryFabricPreferencesDescriptor.
            Allowed values for this property are: "FULL_RECYCLE", "SKIP_RECYCLE", "OPPORTUNISTIC_FULL_RECYCLE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type fabric_recycle_level: str

        """
        self.swagger_types = {
            'customer_desired_firmware_bundle_id': 'str',
            'fabric_recycle_level': 'str'
        }
        self.attribute_map = {
            'customer_desired_firmware_bundle_id': 'customerDesiredFirmwareBundleId',
            'fabric_recycle_level': 'fabricRecycleLevel'
        }
        self._customer_desired_firmware_bundle_id = None
        self._fabric_recycle_level = None

    @property
    def customer_desired_firmware_bundle_id(self):
        """
        Gets the customer_desired_firmware_bundle_id of this MemoryFabricPreferencesDescriptor.
        The desired firmware bundle id on the GPU memory fabric.


        :return: The customer_desired_firmware_bundle_id of this MemoryFabricPreferencesDescriptor.
        :rtype: str
        """
        return self._customer_desired_firmware_bundle_id

    @customer_desired_firmware_bundle_id.setter
    def customer_desired_firmware_bundle_id(self, customer_desired_firmware_bundle_id):
        """
        Sets the customer_desired_firmware_bundle_id of this MemoryFabricPreferencesDescriptor.
        The desired firmware bundle id on the GPU memory fabric.


        :param customer_desired_firmware_bundle_id: The customer_desired_firmware_bundle_id of this MemoryFabricPreferencesDescriptor.
        :type: str
        """
        self._customer_desired_firmware_bundle_id = customer_desired_firmware_bundle_id

    @property
    def fabric_recycle_level(self):
        """
        Gets the fabric_recycle_level of this MemoryFabricPreferencesDescriptor.
        The recycle level of GPU memory fabric.

        Allowed values for this property are: "FULL_RECYCLE", "SKIP_RECYCLE", "OPPORTUNISTIC_FULL_RECYCLE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The fabric_recycle_level of this MemoryFabricPreferencesDescriptor.
        :rtype: str
        """
        return self._fabric_recycle_level

    @fabric_recycle_level.setter
    def fabric_recycle_level(self, fabric_recycle_level):
        """
        Sets the fabric_recycle_level of this MemoryFabricPreferencesDescriptor.
        The recycle level of GPU memory fabric.


        :param fabric_recycle_level: The fabric_recycle_level of this MemoryFabricPreferencesDescriptor.
        :type: str
        """
        allowed_values = ["FULL_RECYCLE", "SKIP_RECYCLE", "OPPORTUNISTIC_FULL_RECYCLE"]
        if not value_allowed_none_or_none_sentinel(fabric_recycle_level, allowed_values):
            fabric_recycle_level = 'UNKNOWN_ENUM_VALUE'
        self._fabric_recycle_level = fabric_recycle_level

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
