# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PlacementConstraintDetails(object):
    """
    The details for providing placement constraints.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PlacementConstraintDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.core.models.HostGroupPlacementConstraintDetails`
        * :class:`~oci.core.models.ComputeBareMetalHostPlacementConstraintDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this PlacementConstraintDetails.
        :type type: str

        """
        self.swagger_types = {
            'type': 'str'
        }
        self.attribute_map = {
            'type': 'type'
        }
        self._type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['type']

        if type == 'HOST_GROUP':
            return 'HostGroupPlacementConstraintDetails'

        if type == 'COMPUTE_BARE_METAL_HOST':
            return 'ComputeBareMetalHostPlacementConstraintDetails'
        else:
            return 'PlacementConstraintDetails'

    @property
    def type(self):
        """
        **[Required]** Gets the type of this PlacementConstraintDetails.
        The type for the placement constraints.
        Use `COMPUTE_BARE_METAL_HOST` when specifying the compute bare metal host OCID.
        Use `HOST_GROUP` when specifying the compute host group OCID.


        :return: The type of this PlacementConstraintDetails.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this PlacementConstraintDetails.
        The type for the placement constraints.
        Use `COMPUTE_BARE_METAL_HOST` when specifying the compute bare metal host OCID.
        Use `HOST_GROUP` when specifying the compute host group OCID.


        :param type: The type of this PlacementConstraintDetails.
        :type: str
        """
        self._type = type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
