# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class FindingsChangeAuditLogSummary(object):
    """
    Summary of audit log of risk updates of findings of specified security assessment.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new FindingsChangeAuditLogSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param key:
            The value to assign to the key property of this FindingsChangeAuditLogSummary.
        :type key: str

        :param finding_key:
            The value to assign to the finding_key property of this FindingsChangeAuditLogSummary.
        :type finding_key: str

        :param finding_title:
            The value to assign to the finding_title property of this FindingsChangeAuditLogSummary.
        :type finding_title: str

        :param assessment_id:
            The value to assign to the assessment_id property of this FindingsChangeAuditLogSummary.
        :type assessment_id: str

        :param target_id:
            The value to assign to the target_id property of this FindingsChangeAuditLogSummary.
        :type target_id: str

        :param time_updated:
            The value to assign to the time_updated property of this FindingsChangeAuditLogSummary.
        :type time_updated: datetime

        :param severity:
            The value to assign to the severity property of this FindingsChangeAuditLogSummary.
        :type severity: str

        :param oracle_defined_severity:
            The value to assign to the oracle_defined_severity property of this FindingsChangeAuditLogSummary.
        :type oracle_defined_severity: str

        :param is_risk_deferred:
            The value to assign to the is_risk_deferred property of this FindingsChangeAuditLogSummary.
        :type is_risk_deferred: bool

        :param previous_severity:
            The value to assign to the previous_severity property of this FindingsChangeAuditLogSummary.
        :type previous_severity: str

        :param justification:
            The value to assign to the justification property of this FindingsChangeAuditLogSummary.
        :type justification: str

        :param time_valid_until:
            The value to assign to the time_valid_until property of this FindingsChangeAuditLogSummary.
        :type time_valid_until: datetime

        :param modified_by:
            The value to assign to the modified_by property of this FindingsChangeAuditLogSummary.
        :type modified_by: str

        """
        self.swagger_types = {
            'key': 'str',
            'finding_key': 'str',
            'finding_title': 'str',
            'assessment_id': 'str',
            'target_id': 'str',
            'time_updated': 'datetime',
            'severity': 'str',
            'oracle_defined_severity': 'str',
            'is_risk_deferred': 'bool',
            'previous_severity': 'str',
            'justification': 'str',
            'time_valid_until': 'datetime',
            'modified_by': 'str'
        }
        self.attribute_map = {
            'key': 'key',
            'finding_key': 'findingKey',
            'finding_title': 'findingTitle',
            'assessment_id': 'assessmentId',
            'target_id': 'targetId',
            'time_updated': 'timeUpdated',
            'severity': 'severity',
            'oracle_defined_severity': 'oracleDefinedSeverity',
            'is_risk_deferred': 'isRiskDeferred',
            'previous_severity': 'previousSeverity',
            'justification': 'justification',
            'time_valid_until': 'timeValidUntil',
            'modified_by': 'modifiedBy'
        }
        self._key = None
        self._finding_key = None
        self._finding_title = None
        self._assessment_id = None
        self._target_id = None
        self._time_updated = None
        self._severity = None
        self._oracle_defined_severity = None
        self._is_risk_deferred = None
        self._previous_severity = None
        self._justification = None
        self._time_valid_until = None
        self._modified_by = None

    @property
    def key(self):
        """
        **[Required]** Gets the key of this FindingsChangeAuditLogSummary.
        The unique key that identifies the finding risk change.


        :return: The key of this FindingsChangeAuditLogSummary.
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """
        Sets the key of this FindingsChangeAuditLogSummary.
        The unique key that identifies the finding risk change.


        :param key: The key of this FindingsChangeAuditLogSummary.
        :type: str
        """
        self._key = key

    @property
    def finding_key(self):
        """
        **[Required]** Gets the finding_key of this FindingsChangeAuditLogSummary.
        The unique key that identifies the finding.


        :return: The finding_key of this FindingsChangeAuditLogSummary.
        :rtype: str
        """
        return self._finding_key

    @finding_key.setter
    def finding_key(self, finding_key):
        """
        Sets the finding_key of this FindingsChangeAuditLogSummary.
        The unique key that identifies the finding.


        :param finding_key: The finding_key of this FindingsChangeAuditLogSummary.
        :type: str
        """
        self._finding_key = finding_key

    @property
    def finding_title(self):
        """
        **[Required]** Gets the finding_title of this FindingsChangeAuditLogSummary.
        The short title for the finding whose risk is being modified.


        :return: The finding_title of this FindingsChangeAuditLogSummary.
        :rtype: str
        """
        return self._finding_title

    @finding_title.setter
    def finding_title(self, finding_title):
        """
        Sets the finding_title of this FindingsChangeAuditLogSummary.
        The short title for the finding whose risk is being modified.


        :param finding_title: The finding_title of this FindingsChangeAuditLogSummary.
        :type: str
        """
        self._finding_title = finding_title

    @property
    def assessment_id(self):
        """
        **[Required]** Gets the assessment_id of this FindingsChangeAuditLogSummary.
        The OCID of the latest security assessment.


        :return: The assessment_id of this FindingsChangeAuditLogSummary.
        :rtype: str
        """
        return self._assessment_id

    @assessment_id.setter
    def assessment_id(self, assessment_id):
        """
        Sets the assessment_id of this FindingsChangeAuditLogSummary.
        The OCID of the latest security assessment.


        :param assessment_id: The assessment_id of this FindingsChangeAuditLogSummary.
        :type: str
        """
        self._assessment_id = assessment_id

    @property
    def target_id(self):
        """
        **[Required]** Gets the target_id of this FindingsChangeAuditLogSummary.
        The OCID of the target database.


        :return: The target_id of this FindingsChangeAuditLogSummary.
        :rtype: str
        """
        return self._target_id

    @target_id.setter
    def target_id(self, target_id):
        """
        Sets the target_id of this FindingsChangeAuditLogSummary.
        The OCID of the target database.


        :param target_id: The target_id of this FindingsChangeAuditLogSummary.
        :type: str
        """
        self._target_id = target_id

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this FindingsChangeAuditLogSummary.
        The date and time the risk level of finding was last updated, in the format defined by `RFC3339`__.

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this FindingsChangeAuditLogSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this FindingsChangeAuditLogSummary.
        The date and time the risk level of finding was last updated, in the format defined by `RFC3339`__.

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this FindingsChangeAuditLogSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def severity(self):
        """
        **[Required]** Gets the severity of this FindingsChangeAuditLogSummary.
        The original severity / risk level of the finding as determined by security assessment.


        :return: The severity of this FindingsChangeAuditLogSummary.
        :rtype: str
        """
        return self._severity

    @severity.setter
    def severity(self, severity):
        """
        Sets the severity of this FindingsChangeAuditLogSummary.
        The original severity / risk level of the finding as determined by security assessment.


        :param severity: The severity of this FindingsChangeAuditLogSummary.
        :type: str
        """
        self._severity = severity

    @property
    def oracle_defined_severity(self):
        """
        **[Required]** Gets the oracle_defined_severity of this FindingsChangeAuditLogSummary.
        The severity of the finding as determined by security assessment by Oracle.


        :return: The oracle_defined_severity of this FindingsChangeAuditLogSummary.
        :rtype: str
        """
        return self._oracle_defined_severity

    @oracle_defined_severity.setter
    def oracle_defined_severity(self, oracle_defined_severity):
        """
        Sets the oracle_defined_severity of this FindingsChangeAuditLogSummary.
        The severity of the finding as determined by security assessment by Oracle.


        :param oracle_defined_severity: The oracle_defined_severity of this FindingsChangeAuditLogSummary.
        :type: str
        """
        self._oracle_defined_severity = oracle_defined_severity

    @property
    def is_risk_deferred(self):
        """
        **[Required]** Gets the is_risk_deferred of this FindingsChangeAuditLogSummary.
        Determines if the user has deferred the risk level of this finding when he is ok with it
        and does not plan to do anything about it.


        :return: The is_risk_deferred of this FindingsChangeAuditLogSummary.
        :rtype: bool
        """
        return self._is_risk_deferred

    @is_risk_deferred.setter
    def is_risk_deferred(self, is_risk_deferred):
        """
        Sets the is_risk_deferred of this FindingsChangeAuditLogSummary.
        Determines if the user has deferred the risk level of this finding when he is ok with it
        and does not plan to do anything about it.


        :param is_risk_deferred: The is_risk_deferred of this FindingsChangeAuditLogSummary.
        :type: bool
        """
        self._is_risk_deferred = is_risk_deferred

    @property
    def previous_severity(self):
        """
        **[Required]** Gets the previous_severity of this FindingsChangeAuditLogSummary.
        If the risk level is changed more than once, the previous modified value.


        :return: The previous_severity of this FindingsChangeAuditLogSummary.
        :rtype: str
        """
        return self._previous_severity

    @previous_severity.setter
    def previous_severity(self, previous_severity):
        """
        Sets the previous_severity of this FindingsChangeAuditLogSummary.
        If the risk level is changed more than once, the previous modified value.


        :param previous_severity: The previous_severity of this FindingsChangeAuditLogSummary.
        :type: str
        """
        self._previous_severity = previous_severity

    @property
    def justification(self):
        """
        **[Required]** Gets the justification of this FindingsChangeAuditLogSummary.
        The justification given by the user for accepting or modifying the risk level.


        :return: The justification of this FindingsChangeAuditLogSummary.
        :rtype: str
        """
        return self._justification

    @justification.setter
    def justification(self, justification):
        """
        Sets the justification of this FindingsChangeAuditLogSummary.
        The justification given by the user for accepting or modifying the risk level.


        :param justification: The justification of this FindingsChangeAuditLogSummary.
        :type: str
        """
        self._justification = justification

    @property
    def time_valid_until(self):
        """
        Gets the time_valid_until of this FindingsChangeAuditLogSummary.
        The date and time, in the format defined by `RFC3339`__,
        the risk level change as updated by user is valid until. After this date passes, the risk level
        will be that of what is determined by the latest security assessment.

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_valid_until of this FindingsChangeAuditLogSummary.
        :rtype: datetime
        """
        return self._time_valid_until

    @time_valid_until.setter
    def time_valid_until(self, time_valid_until):
        """
        Sets the time_valid_until of this FindingsChangeAuditLogSummary.
        The date and time, in the format defined by `RFC3339`__,
        the risk level change as updated by user is valid until. After this date passes, the risk level
        will be that of what is determined by the latest security assessment.

        __ https://tools.ietf.org/html/rfc3339


        :param time_valid_until: The time_valid_until of this FindingsChangeAuditLogSummary.
        :type: datetime
        """
        self._time_valid_until = time_valid_until

    @property
    def modified_by(self):
        """
        **[Required]** Gets the modified_by of this FindingsChangeAuditLogSummary.
        The user who initiated change of risk level of the finding


        :return: The modified_by of this FindingsChangeAuditLogSummary.
        :rtype: str
        """
        return self._modified_by

    @modified_by.setter
    def modified_by(self, modified_by):
        """
        Sets the modified_by of this FindingsChangeAuditLogSummary.
        The user who initiated change of risk level of the finding


        :param modified_by: The modified_by of this FindingsChangeAuditLogSummary.
        :type: str
        """
        self._modified_by = modified_by

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
