# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MlApplicationPackageArguments(object):
    """
    List of ML Application package arguments provided during ML Application package upload.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MlApplicationPackageArguments object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param arguments:
            The value to assign to the arguments property of this MlApplicationPackageArguments.
        :type arguments: list[oci.data_science.models.MlApplicationPackageArgumentDetails]

        """
        self.swagger_types = {
            'arguments': 'list[MlApplicationPackageArgumentDetails]'
        }
        self.attribute_map = {
            'arguments': 'arguments'
        }
        self._arguments = None

    @property
    def arguments(self):
        """
        Gets the arguments of this MlApplicationPackageArguments.
        Array of the ML Application package arguments


        :return: The arguments of this MlApplicationPackageArguments.
        :rtype: list[oci.data_science.models.MlApplicationPackageArgumentDetails]
        """
        return self._arguments

    @arguments.setter
    def arguments(self, arguments):
        """
        Sets the arguments of this MlApplicationPackageArguments.
        Array of the ML Application package arguments


        :param arguments: The arguments of this MlApplicationPackageArguments.
        :type: list[oci.data_science.models.MlApplicationPackageArgumentDetails]
        """
        self._arguments = arguments

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
