# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101

from .pipeline_step_details import PipelineStepDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PipelineDataflowStepDetails(PipelineStepDetails):
    """
    The type of step where the dataflow application is pre-created by the user.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PipelineDataflowStepDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.data_science.models.PipelineDataflowStepDetails.step_type` attribute
        of this class is ``DATAFLOW`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param step_type:
            The value to assign to the step_type property of this PipelineDataflowStepDetails.
            Allowed values for this property are: "ML_JOB", "CUSTOM_SCRIPT", "CONTAINER", "DATAFLOW"
        :type step_type: str

        :param step_name:
            The value to assign to the step_name property of this PipelineDataflowStepDetails.
        :type step_name: str

        :param description:
            The value to assign to the description property of this PipelineDataflowStepDetails.
        :type description: str

        :param depends_on:
            The value to assign to the depends_on property of this PipelineDataflowStepDetails.
        :type depends_on: list[str]

        :param step_configuration_details:
            The value to assign to the step_configuration_details property of this PipelineDataflowStepDetails.
        :type step_configuration_details: oci.data_science.models.PipelineStepConfigurationDetails

        :param application_id:
            The value to assign to the application_id property of this PipelineDataflowStepDetails.
        :type application_id: str

        :param step_dataflow_configuration_details:
            The value to assign to the step_dataflow_configuration_details property of this PipelineDataflowStepDetails.
        :type step_dataflow_configuration_details: oci.data_science.models.PipelineDataflowConfigurationDetails

        """
        self.swagger_types = {
            'step_type': 'str',
            'step_name': 'str',
            'description': 'str',
            'depends_on': 'list[str]',
            'step_configuration_details': 'PipelineStepConfigurationDetails',
            'application_id': 'str',
            'step_dataflow_configuration_details': 'PipelineDataflowConfigurationDetails'
        }
        self.attribute_map = {
            'step_type': 'stepType',
            'step_name': 'stepName',
            'description': 'description',
            'depends_on': 'dependsOn',
            'step_configuration_details': 'stepConfigurationDetails',
            'application_id': 'applicationId',
            'step_dataflow_configuration_details': 'stepDataflowConfigurationDetails'
        }
        self._step_type = None
        self._step_name = None
        self._description = None
        self._depends_on = None
        self._step_configuration_details = None
        self._application_id = None
        self._step_dataflow_configuration_details = None
        self._step_type = 'DATAFLOW'

    @property
    def application_id(self):
        """
        **[Required]** Gets the application_id of this PipelineDataflowStepDetails.
        The `OCID`__ of the dataflow application to be used as a step.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The application_id of this PipelineDataflowStepDetails.
        :rtype: str
        """
        return self._application_id

    @application_id.setter
    def application_id(self, application_id):
        """
        Sets the application_id of this PipelineDataflowStepDetails.
        The `OCID`__ of the dataflow application to be used as a step.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param application_id: The application_id of this PipelineDataflowStepDetails.
        :type: str
        """
        self._application_id = application_id

    @property
    def step_dataflow_configuration_details(self):
        """
        Gets the step_dataflow_configuration_details of this PipelineDataflowStepDetails.

        :return: The step_dataflow_configuration_details of this PipelineDataflowStepDetails.
        :rtype: oci.data_science.models.PipelineDataflowConfigurationDetails
        """
        return self._step_dataflow_configuration_details

    @step_dataflow_configuration_details.setter
    def step_dataflow_configuration_details(self, step_dataflow_configuration_details):
        """
        Sets the step_dataflow_configuration_details of this PipelineDataflowStepDetails.

        :param step_dataflow_configuration_details: The step_dataflow_configuration_details of this PipelineDataflowStepDetails.
        :type: oci.data_science.models.PipelineDataflowConfigurationDetails
        """
        self._step_dataflow_configuration_details = step_dataflow_configuration_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
