# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DbSystemStoragePerformanceSummary(object):
    """
    Representation of storage performance summary per shapeType .
    """

    #: A constant which can be used with the shape_type property of a DbSystemStoragePerformanceSummary.
    #: This constant has a value of "AMD"
    SHAPE_TYPE_AMD = "AMD"

    #: A constant which can be used with the shape_type property of a DbSystemStoragePerformanceSummary.
    #: This constant has a value of "INTEL"
    SHAPE_TYPE_INTEL = "INTEL"

    #: A constant which can be used with the shape_type property of a DbSystemStoragePerformanceSummary.
    #: This constant has a value of "INTEL_FLEX_X9"
    SHAPE_TYPE_INTEL_FLEX_X9 = "INTEL_FLEX_X9"

    #: A constant which can be used with the shape_type property of a DbSystemStoragePerformanceSummary.
    #: This constant has a value of "AMPERE_FLEX_A1"
    SHAPE_TYPE_AMPERE_FLEX_A1 = "AMPERE_FLEX_A1"

    #: A constant which can be used with the shape_type property of a DbSystemStoragePerformanceSummary.
    #: This constant has a value of "STANDARD_X86"
    SHAPE_TYPE_STANDARD_X86 = "STANDARD_X86"

    def __init__(self, **kwargs):
        """
        Initializes a new DbSystemStoragePerformanceSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this DbSystemStoragePerformanceSummary.
        :type compartment_id: str

        :param shape_type:
            The value to assign to the shape_type property of this DbSystemStoragePerformanceSummary.
            Allowed values for this property are: "AMD", "INTEL", "INTEL_FLEX_X9", "AMPERE_FLEX_A1", "STANDARD_X86", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type shape_type: str

        :param data_storage_performance_list:
            The value to assign to the data_storage_performance_list property of this DbSystemStoragePerformanceSummary.
        :type data_storage_performance_list: list[oci.database.models.StoragePerformanceDetails]

        :param reco_storage_performance_list:
            The value to assign to the reco_storage_performance_list property of this DbSystemStoragePerformanceSummary.
        :type reco_storage_performance_list: list[oci.database.models.StoragePerformanceDetails]

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'shape_type': 'str',
            'data_storage_performance_list': 'list[StoragePerformanceDetails]',
            'reco_storage_performance_list': 'list[StoragePerformanceDetails]'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'shape_type': 'shapeType',
            'data_storage_performance_list': 'dataStoragePerformanceList',
            'reco_storage_performance_list': 'recoStoragePerformanceList'
        }
        self._compartment_id = None
        self._shape_type = None
        self._data_storage_performance_list = None
        self._reco_storage_performance_list = None

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this DbSystemStoragePerformanceSummary.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this DbSystemStoragePerformanceSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this DbSystemStoragePerformanceSummary.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this DbSystemStoragePerformanceSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def shape_type(self):
        """
        **[Required]** Gets the shape_type of this DbSystemStoragePerformanceSummary.
        ShapeType of the DbSystems INTEL , AMD, INTEL_FLEX_X9 or AMPERE_FLEX_A1

        Allowed values for this property are: "AMD", "INTEL", "INTEL_FLEX_X9", "AMPERE_FLEX_A1", "STANDARD_X86", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The shape_type of this DbSystemStoragePerformanceSummary.
        :rtype: str
        """
        return self._shape_type

    @shape_type.setter
    def shape_type(self, shape_type):
        """
        Sets the shape_type of this DbSystemStoragePerformanceSummary.
        ShapeType of the DbSystems INTEL , AMD, INTEL_FLEX_X9 or AMPERE_FLEX_A1


        :param shape_type: The shape_type of this DbSystemStoragePerformanceSummary.
        :type: str
        """
        allowed_values = ["AMD", "INTEL", "INTEL_FLEX_X9", "AMPERE_FLEX_A1", "STANDARD_X86"]
        if not value_allowed_none_or_none_sentinel(shape_type, allowed_values):
            shape_type = 'UNKNOWN_ENUM_VALUE'
        self._shape_type = shape_type

    @property
    def data_storage_performance_list(self):
        """
        **[Required]** Gets the data_storage_performance_list of this DbSystemStoragePerformanceSummary.
        List of storage performance for the DATA disks


        :return: The data_storage_performance_list of this DbSystemStoragePerformanceSummary.
        :rtype: list[oci.database.models.StoragePerformanceDetails]
        """
        return self._data_storage_performance_list

    @data_storage_performance_list.setter
    def data_storage_performance_list(self, data_storage_performance_list):
        """
        Sets the data_storage_performance_list of this DbSystemStoragePerformanceSummary.
        List of storage performance for the DATA disks


        :param data_storage_performance_list: The data_storage_performance_list of this DbSystemStoragePerformanceSummary.
        :type: list[oci.database.models.StoragePerformanceDetails]
        """
        self._data_storage_performance_list = data_storage_performance_list

    @property
    def reco_storage_performance_list(self):
        """
        **[Required]** Gets the reco_storage_performance_list of this DbSystemStoragePerformanceSummary.
        List of storage performance for the RECO disks


        :return: The reco_storage_performance_list of this DbSystemStoragePerformanceSummary.
        :rtype: list[oci.database.models.StoragePerformanceDetails]
        """
        return self._reco_storage_performance_list

    @reco_storage_performance_list.setter
    def reco_storage_performance_list(self, reco_storage_performance_list):
        """
        Sets the reco_storage_performance_list of this DbSystemStoragePerformanceSummary.
        List of storage performance for the RECO disks


        :param reco_storage_performance_list: The reco_storage_performance_list of this DbSystemStoragePerformanceSummary.
        :type: list[oci.database.models.StoragePerformanceDetails]
        """
        self._reco_storage_performance_list = reco_storage_performance_list

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
