# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918

from .encryption_key_location_details import EncryptionKeyLocationDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ExternalHsmEncryptionDetails(EncryptionKeyLocationDetails):
    """
    Details for External HSM Input
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ExternalHsmEncryptionDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.database.models.ExternalHsmEncryptionDetails.provider_type` attribute
        of this class is ``EXTERNAL`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param provider_type:
            The value to assign to the provider_type property of this ExternalHsmEncryptionDetails.
            Allowed values for this property are: "EXTERNAL", "AZURE", "GCP", "AWS"
        :type provider_type: str

        :param hsm_password:
            The value to assign to the hsm_password property of this ExternalHsmEncryptionDetails.
        :type hsm_password: str

        """
        self.swagger_types = {
            'provider_type': 'str',
            'hsm_password': 'str'
        }
        self.attribute_map = {
            'provider_type': 'providerType',
            'hsm_password': 'hsmPassword'
        }
        self._provider_type = None
        self._hsm_password = None
        self._provider_type = 'EXTERNAL'

    @property
    def hsm_password(self):
        """
        **[Required]** Gets the hsm_password of this ExternalHsmEncryptionDetails.
        Provide the HSM password as you would in RDBMS for External HSM.


        :return: The hsm_password of this ExternalHsmEncryptionDetails.
        :rtype: str
        """
        return self._hsm_password

    @hsm_password.setter
    def hsm_password(self, hsm_password):
        """
        Sets the hsm_password of this ExternalHsmEncryptionDetails.
        Provide the HSM password as you would in RDBMS for External HSM.


        :param hsm_password: The hsm_password of this ExternalHsmEncryptionDetails.
        :type: str
        """
        self._hsm_password = hsm_password

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
