# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CloudDbSystemDiscoverySummary(object):
    """
    The summary of a cloud DB system.
    """

    #: A constant which can be used with the deployment_type property of a CloudDbSystemDiscoverySummary.
    #: This constant has a value of "VM"
    DEPLOYMENT_TYPE_VM = "VM"

    #: A constant which can be used with the deployment_type property of a CloudDbSystemDiscoverySummary.
    #: This constant has a value of "EXADATA"
    DEPLOYMENT_TYPE_EXADATA = "EXADATA"

    #: A constant which can be used with the deployment_type property of a CloudDbSystemDiscoverySummary.
    #: This constant has a value of "EXADATA_CC"
    DEPLOYMENT_TYPE_EXADATA_CC = "EXADATA_CC"

    #: A constant which can be used with the deployment_type property of a CloudDbSystemDiscoverySummary.
    #: This constant has a value of "EXADATA_XS"
    DEPLOYMENT_TYPE_EXADATA_XS = "EXADATA_XS"

    def __init__(self, **kwargs):
        """
        Initializes a new CloudDbSystemDiscoverySummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this CloudDbSystemDiscoverySummary.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this CloudDbSystemDiscoverySummary.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CloudDbSystemDiscoverySummary.
        :type compartment_id: str

        :param agent_id:
            The value to assign to the agent_id property of this CloudDbSystemDiscoverySummary.
        :type agent_id: str

        :param dbaas_parent_infrastructure_id:
            The value to assign to the dbaas_parent_infrastructure_id property of this CloudDbSystemDiscoverySummary.
        :type dbaas_parent_infrastructure_id: str

        :param deployment_type:
            The value to assign to the deployment_type property of this CloudDbSystemDiscoverySummary.
            Allowed values for this property are: "VM", "EXADATA", "EXADATA_CC", "EXADATA_XS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type deployment_type: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this CloudDbSystemDiscoverySummary.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this CloudDbSystemDiscoverySummary.
        :type lifecycle_details: str

        :param time_created:
            The value to assign to the time_created property of this CloudDbSystemDiscoverySummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this CloudDbSystemDiscoverySummary.
        :type time_updated: datetime

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CloudDbSystemDiscoverySummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CloudDbSystemDiscoverySummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this CloudDbSystemDiscoverySummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'compartment_id': 'str',
            'agent_id': 'str',
            'dbaas_parent_infrastructure_id': 'str',
            'deployment_type': 'str',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'agent_id': 'agentId',
            'dbaas_parent_infrastructure_id': 'dbaasParentInfrastructureId',
            'deployment_type': 'deploymentType',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._display_name = None
        self._compartment_id = None
        self._agent_id = None
        self._dbaas_parent_infrastructure_id = None
        self._deployment_type = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._time_created = None
        self._time_updated = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this CloudDbSystemDiscoverySummary.
        The `OCID`__ of the cloud DB system discovery.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this CloudDbSystemDiscoverySummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this CloudDbSystemDiscoverySummary.
        The `OCID`__ of the cloud DB system discovery.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this CloudDbSystemDiscoverySummary.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this CloudDbSystemDiscoverySummary.
        The user-friendly name for the DB system. The name does not have to be unique.


        :return: The display_name of this CloudDbSystemDiscoverySummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CloudDbSystemDiscoverySummary.
        The user-friendly name for the DB system. The name does not have to be unique.


        :param display_name: The display_name of this CloudDbSystemDiscoverySummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CloudDbSystemDiscoverySummary.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CloudDbSystemDiscoverySummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CloudDbSystemDiscoverySummary.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CloudDbSystemDiscoverySummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def agent_id(self):
        """
        **[Required]** Gets the agent_id of this CloudDbSystemDiscoverySummary.
        The `OCID`__ of the management agent
        used for the cloud DB system discovery.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The agent_id of this CloudDbSystemDiscoverySummary.
        :rtype: str
        """
        return self._agent_id

    @agent_id.setter
    def agent_id(self, agent_id):
        """
        Sets the agent_id of this CloudDbSystemDiscoverySummary.
        The `OCID`__ of the management agent
        used for the cloud DB system discovery.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param agent_id: The agent_id of this CloudDbSystemDiscoverySummary.
        :type: str
        """
        self._agent_id = agent_id

    @property
    def dbaas_parent_infrastructure_id(self):
        """
        **[Required]** Gets the dbaas_parent_infrastructure_id of this CloudDbSystemDiscoverySummary.
        The `OCID`__ of the parent cloud DB Infrastructure. For VM Dbsystems ,
        it will be the DBSystem Id. For ExaCS and ExaCC,  it will be the cloudVmClusterId and vmClusterId respectively.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The dbaas_parent_infrastructure_id of this CloudDbSystemDiscoverySummary.
        :rtype: str
        """
        return self._dbaas_parent_infrastructure_id

    @dbaas_parent_infrastructure_id.setter
    def dbaas_parent_infrastructure_id(self, dbaas_parent_infrastructure_id):
        """
        Sets the dbaas_parent_infrastructure_id of this CloudDbSystemDiscoverySummary.
        The `OCID`__ of the parent cloud DB Infrastructure. For VM Dbsystems ,
        it will be the DBSystem Id. For ExaCS and ExaCC,  it will be the cloudVmClusterId and vmClusterId respectively.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param dbaas_parent_infrastructure_id: The dbaas_parent_infrastructure_id of this CloudDbSystemDiscoverySummary.
        :type: str
        """
        self._dbaas_parent_infrastructure_id = dbaas_parent_infrastructure_id

    @property
    def deployment_type(self):
        """
        **[Required]** Gets the deployment_type of this CloudDbSystemDiscoverySummary.
        The deployment type of cloud dbsystem.

        Allowed values for this property are: "VM", "EXADATA", "EXADATA_CC", "EXADATA_XS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The deployment_type of this CloudDbSystemDiscoverySummary.
        :rtype: str
        """
        return self._deployment_type

    @deployment_type.setter
    def deployment_type(self, deployment_type):
        """
        Sets the deployment_type of this CloudDbSystemDiscoverySummary.
        The deployment type of cloud dbsystem.


        :param deployment_type: The deployment_type of this CloudDbSystemDiscoverySummary.
        :type: str
        """
        allowed_values = ["VM", "EXADATA", "EXADATA_CC", "EXADATA_XS"]
        if not value_allowed_none_or_none_sentinel(deployment_type, allowed_values):
            deployment_type = 'UNKNOWN_ENUM_VALUE'
        self._deployment_type = deployment_type

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this CloudDbSystemDiscoverySummary.
        The current lifecycle state of the cloud DB system discovery resource.


        :return: The lifecycle_state of this CloudDbSystemDiscoverySummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this CloudDbSystemDiscoverySummary.
        The current lifecycle state of the cloud DB system discovery resource.


        :param lifecycle_state: The lifecycle_state of this CloudDbSystemDiscoverySummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this CloudDbSystemDiscoverySummary.
        Additional information about the current lifecycle state.


        :return: The lifecycle_details of this CloudDbSystemDiscoverySummary.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this CloudDbSystemDiscoverySummary.
        Additional information about the current lifecycle state.


        :param lifecycle_details: The lifecycle_details of this CloudDbSystemDiscoverySummary.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this CloudDbSystemDiscoverySummary.
        The date and time the cloud DB system discovery was created.


        :return: The time_created of this CloudDbSystemDiscoverySummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this CloudDbSystemDiscoverySummary.
        The date and time the cloud DB system discovery was created.


        :param time_created: The time_created of this CloudDbSystemDiscoverySummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this CloudDbSystemDiscoverySummary.
        The date and time the cloud DB system discovery was last updated.


        :return: The time_updated of this CloudDbSystemDiscoverySummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this CloudDbSystemDiscoverySummary.
        The date and time the cloud DB system discovery was last updated.


        :param time_updated: The time_updated of this CloudDbSystemDiscoverySummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CloudDbSystemDiscoverySummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CloudDbSystemDiscoverySummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CloudDbSystemDiscoverySummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CloudDbSystemDiscoverySummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CloudDbSystemDiscoverySummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CloudDbSystemDiscoverySummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CloudDbSystemDiscoverySummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CloudDbSystemDiscoverySummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this CloudDbSystemDiscoverySummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        System tags can be viewed by users, but can only be created by the system.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The system_tags of this CloudDbSystemDiscoverySummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this CloudDbSystemDiscoverySummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        System tags can be viewed by users, but can only be created by the system.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param system_tags: The system_tags of this CloudDbSystemDiscoverySummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
