# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class HeatWaveFleetMetricDefinition(object):
    """
    An aggregated metric for a HeatWave cluster.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new HeatWaveFleetMetricDefinition object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param metric_name:
            The value to assign to the metric_name property of this HeatWaveFleetMetricDefinition.
        :type metric_name: str

        :param metric_value:
            The value to assign to the metric_value property of this HeatWaveFleetMetricDefinition.
        :type metric_value: float

        :param timestamp:
            The value to assign to the timestamp property of this HeatWaveFleetMetricDefinition.
        :type timestamp: datetime

        :param dimensions:
            The value to assign to the dimensions property of this HeatWaveFleetMetricDefinition.
        :type dimensions: list[oci.database_management.models.MetricDimensionDefinition]

        :param unit:
            The value to assign to the unit property of this HeatWaveFleetMetricDefinition.
        :type unit: str

        """
        self.swagger_types = {
            'metric_name': 'str',
            'metric_value': 'float',
            'timestamp': 'datetime',
            'dimensions': 'list[MetricDimensionDefinition]',
            'unit': 'str'
        }
        self.attribute_map = {
            'metric_name': 'metricName',
            'metric_value': 'metricValue',
            'timestamp': 'timestamp',
            'dimensions': 'dimensions',
            'unit': 'unit'
        }
        self._metric_name = None
        self._metric_value = None
        self._timestamp = None
        self._dimensions = None
        self._unit = None

    @property
    def metric_name(self):
        """
        **[Required]** Gets the metric_name of this HeatWaveFleetMetricDefinition.
        The name of the metric.


        :return: The metric_name of this HeatWaveFleetMetricDefinition.
        :rtype: str
        """
        return self._metric_name

    @metric_name.setter
    def metric_name(self, metric_name):
        """
        Sets the metric_name of this HeatWaveFleetMetricDefinition.
        The name of the metric.


        :param metric_name: The metric_name of this HeatWaveFleetMetricDefinition.
        :type: str
        """
        self._metric_name = metric_name

    @property
    def metric_value(self):
        """
        **[Required]** Gets the metric_value of this HeatWaveFleetMetricDefinition.
        The value of the metric.


        :return: The metric_value of this HeatWaveFleetMetricDefinition.
        :rtype: float
        """
        return self._metric_value

    @metric_value.setter
    def metric_value(self, metric_value):
        """
        Sets the metric_value of this HeatWaveFleetMetricDefinition.
        The value of the metric.


        :param metric_value: The metric_value of this HeatWaveFleetMetricDefinition.
        :type: float
        """
        self._metric_value = metric_value

    @property
    def timestamp(self):
        """
        **[Required]** Gets the timestamp of this HeatWaveFleetMetricDefinition.
        The data point date and time in UTC in ISO-8601 format.


        :return: The timestamp of this HeatWaveFleetMetricDefinition.
        :rtype: datetime
        """
        return self._timestamp

    @timestamp.setter
    def timestamp(self, timestamp):
        """
        Sets the timestamp of this HeatWaveFleetMetricDefinition.
        The data point date and time in UTC in ISO-8601 format.


        :param timestamp: The timestamp of this HeatWaveFleetMetricDefinition.
        :type: datetime
        """
        self._timestamp = timestamp

    @property
    def dimensions(self):
        """
        **[Required]** Gets the dimensions of this HeatWaveFleetMetricDefinition.
        The dimensions of the metric.


        :return: The dimensions of this HeatWaveFleetMetricDefinition.
        :rtype: list[oci.database_management.models.MetricDimensionDefinition]
        """
        return self._dimensions

    @dimensions.setter
    def dimensions(self, dimensions):
        """
        Sets the dimensions of this HeatWaveFleetMetricDefinition.
        The dimensions of the metric.


        :param dimensions: The dimensions of this HeatWaveFleetMetricDefinition.
        :type: list[oci.database_management.models.MetricDimensionDefinition]
        """
        self._dimensions = dimensions

    @property
    def unit(self):
        """
        **[Required]** Gets the unit of this HeatWaveFleetMetricDefinition.
        The unit of the metric value.


        :return: The unit of this HeatWaveFleetMetricDefinition.
        :rtype: str
        """
        return self._unit

    @unit.setter
    def unit(self, unit):
        """
        Sets the unit of this HeatWaveFleetMetricDefinition.
        The unit of the metric value.


        :param unit: The unit of this HeatWaveFleetMetricDefinition.
        :type: str
        """
        self._unit = unit

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
