# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240102


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ResourcesPatchComplianceSummary(object):
    """
    Summary of resources and their patch compliance.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ResourcesPatchComplianceSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param total_resources_count:
            The value to assign to the total_resources_count property of this ResourcesPatchComplianceSummary.
        :type total_resources_count: int

        :param up_to_date_resources_count:
            The value to assign to the up_to_date_resources_count property of this ResourcesPatchComplianceSummary.
        :type up_to_date_resources_count: int

        :param non_compliant_resources_count:
            The value to assign to the non_compliant_resources_count property of this ResourcesPatchComplianceSummary.
        :type non_compliant_resources_count: int

        :param not_subscribed_resources_count:
            The value to assign to the not_subscribed_resources_count property of this ResourcesPatchComplianceSummary.
        :type not_subscribed_resources_count: int

        :param not_dblm_registered_resources_count:
            The value to assign to the not_dblm_registered_resources_count property of this ResourcesPatchComplianceSummary.
        :type not_dblm_registered_resources_count: int

        """
        self.swagger_types = {
            'total_resources_count': 'int',
            'up_to_date_resources_count': 'int',
            'non_compliant_resources_count': 'int',
            'not_subscribed_resources_count': 'int',
            'not_dblm_registered_resources_count': 'int'
        }
        self.attribute_map = {
            'total_resources_count': 'totalResourcesCount',
            'up_to_date_resources_count': 'upToDateResourcesCount',
            'non_compliant_resources_count': 'nonCompliantResourcesCount',
            'not_subscribed_resources_count': 'notSubscribedResourcesCount',
            'not_dblm_registered_resources_count': 'notDblmRegisteredResourcesCount'
        }
        self._total_resources_count = None
        self._up_to_date_resources_count = None
        self._non_compliant_resources_count = None
        self._not_subscribed_resources_count = None
        self._not_dblm_registered_resources_count = None

    @property
    def total_resources_count(self):
        """
        Gets the total_resources_count of this ResourcesPatchComplianceSummary.
        Total number of resources.


        :return: The total_resources_count of this ResourcesPatchComplianceSummary.
        :rtype: int
        """
        return self._total_resources_count

    @total_resources_count.setter
    def total_resources_count(self, total_resources_count):
        """
        Sets the total_resources_count of this ResourcesPatchComplianceSummary.
        Total number of resources.


        :param total_resources_count: The total_resources_count of this ResourcesPatchComplianceSummary.
        :type: int
        """
        self._total_resources_count = total_resources_count

    @property
    def up_to_date_resources_count(self):
        """
        Gets the up_to_date_resources_count of this ResourcesPatchComplianceSummary.
        Total number of resources that are up to date.


        :return: The up_to_date_resources_count of this ResourcesPatchComplianceSummary.
        :rtype: int
        """
        return self._up_to_date_resources_count

    @up_to_date_resources_count.setter
    def up_to_date_resources_count(self, up_to_date_resources_count):
        """
        Sets the up_to_date_resources_count of this ResourcesPatchComplianceSummary.
        Total number of resources that are up to date.


        :param up_to_date_resources_count: The up_to_date_resources_count of this ResourcesPatchComplianceSummary.
        :type: int
        """
        self._up_to_date_resources_count = up_to_date_resources_count

    @property
    def non_compliant_resources_count(self):
        """
        Gets the non_compliant_resources_count of this ResourcesPatchComplianceSummary.
        Total number of  non-compliant resources.


        :return: The non_compliant_resources_count of this ResourcesPatchComplianceSummary.
        :rtype: int
        """
        return self._non_compliant_resources_count

    @non_compliant_resources_count.setter
    def non_compliant_resources_count(self, non_compliant_resources_count):
        """
        Sets the non_compliant_resources_count of this ResourcesPatchComplianceSummary.
        Total number of  non-compliant resources.


        :param non_compliant_resources_count: The non_compliant_resources_count of this ResourcesPatchComplianceSummary.
        :type: int
        """
        self._non_compliant_resources_count = non_compliant_resources_count

    @property
    def not_subscribed_resources_count(self):
        """
        Gets the not_subscribed_resources_count of this ResourcesPatchComplianceSummary.
        Total number of resources that are not subscribed.


        :return: The not_subscribed_resources_count of this ResourcesPatchComplianceSummary.
        :rtype: int
        """
        return self._not_subscribed_resources_count

    @not_subscribed_resources_count.setter
    def not_subscribed_resources_count(self, not_subscribed_resources_count):
        """
        Sets the not_subscribed_resources_count of this ResourcesPatchComplianceSummary.
        Total number of resources that are not subscribed.


        :param not_subscribed_resources_count: The not_subscribed_resources_count of this ResourcesPatchComplianceSummary.
        :type: int
        """
        self._not_subscribed_resources_count = not_subscribed_resources_count

    @property
    def not_dblm_registered_resources_count(self):
        """
        Gets the not_dblm_registered_resources_count of this ResourcesPatchComplianceSummary.
        Total number of resources that are not registered to DBLM.


        :return: The not_dblm_registered_resources_count of this ResourcesPatchComplianceSummary.
        :rtype: int
        """
        return self._not_dblm_registered_resources_count

    @not_dblm_registered_resources_count.setter
    def not_dblm_registered_resources_count(self, not_dblm_registered_resources_count):
        """
        Sets the not_dblm_registered_resources_count of this ResourcesPatchComplianceSummary.
        Total number of resources that are not registered to DBLM.


        :param not_dblm_registered_resources_count: The not_dblm_registered_resources_count of this ResourcesPatchComplianceSummary.
        :type: int
        """
        self._not_dblm_registered_resources_count = not_dblm_registered_resources_count

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
