# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240501


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ServiceRoleDetail(object):
    """
    Service Role details object.
    """

    #: A constant which can be used with the service_type property of a ServiceRoleDetail.
    #: This constant has a value of "KMS"
    SERVICE_TYPE_KMS = "KMS"

    def __init__(self, **kwargs):
        """
        Initializes a new ServiceRoleDetail object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param role_arn:
            The value to assign to the role_arn property of this ServiceRoleDetail.
        :type role_arn: str

        :param service_private_endpoint:
            The value to assign to the service_private_endpoint property of this ServiceRoleDetail.
        :type service_private_endpoint: str

        :param service_type:
            The value to assign to the service_type property of this ServiceRoleDetail.
            Allowed values for this property are: "KMS"
        :type service_type: str

        """
        self.swagger_types = {
            'role_arn': 'str',
            'service_private_endpoint': 'str',
            'service_type': 'str'
        }
        self.attribute_map = {
            'role_arn': 'roleArn',
            'service_private_endpoint': 'servicePrivateEndpoint',
            'service_type': 'serviceType'
        }
        self._role_arn = None
        self._service_private_endpoint = None
        self._service_type = None

    @property
    def role_arn(self):
        """
        **[Required]** Gets the role_arn of this ServiceRoleDetail.
        Amazon resource name AWSof the IAM role.


        :return: The role_arn of this ServiceRoleDetail.
        :rtype: str
        """
        return self._role_arn

    @role_arn.setter
    def role_arn(self, role_arn):
        """
        Sets the role_arn of this ServiceRoleDetail.
        Amazon resource name AWSof the IAM role.


        :param role_arn: The role_arn of this ServiceRoleDetail.
        :type: str
        """
        self._role_arn = role_arn

    @property
    def service_private_endpoint(self):
        """
        **[Required]** Gets the service_private_endpoint of this ServiceRoleDetail.
        Private endpoint of the AWS service.


        :return: The service_private_endpoint of this ServiceRoleDetail.
        :rtype: str
        """
        return self._service_private_endpoint

    @service_private_endpoint.setter
    def service_private_endpoint(self, service_private_endpoint):
        """
        Sets the service_private_endpoint of this ServiceRoleDetail.
        Private endpoint of the AWS service.


        :param service_private_endpoint: The service_private_endpoint of this ServiceRoleDetail.
        :type: str
        """
        self._service_private_endpoint = service_private_endpoint

    @property
    def service_type(self):
        """
        **[Required]** Gets the service_type of this ServiceRoleDetail.
        Type of service.

        Allowed values for this property are: "KMS"


        :return: The service_type of this ServiceRoleDetail.
        :rtype: str
        """
        return self._service_type

    @service_type.setter
    def service_type(self, service_type):
        """
        Sets the service_type of this ServiceRoleDetail.
        Type of service.


        :param service_type: The service_type of this ServiceRoleDetail.
        :type: str
        """
        allowed_values = ["KMS"]
        if not value_allowed_none_or_none_sentinel(service_type, allowed_values):
            raise ValueError(
                f"Invalid value for `service_type`, must be None or one of {allowed_values}"
            )
        self._service_type = service_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
