# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ProtectedBranch(object):
    """
    Holds information used to restrict certain actions on branches
    """

    #: A constant which can be used with the protection_levels property of a ProtectedBranch.
    #: This constant has a value of "READ_ONLY"
    PROTECTION_LEVELS_READ_ONLY = "READ_ONLY"

    #: A constant which can be used with the protection_levels property of a ProtectedBranch.
    #: This constant has a value of "PULL_REQUEST_MERGE_ONLY"
    PROTECTION_LEVELS_PULL_REQUEST_MERGE_ONLY = "PULL_REQUEST_MERGE_ONLY"

    def __init__(self, **kwargs):
        """
        Initializes a new ProtectedBranch object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param branch_name:
            The value to assign to the branch_name property of this ProtectedBranch.
        :type branch_name: str

        :param protection_levels:
            The value to assign to the protection_levels property of this ProtectedBranch.
            Allowed values for items in this list are: "READ_ONLY", "PULL_REQUEST_MERGE_ONLY", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type protection_levels: list[str]

        :param freeform_tags:
            The value to assign to the freeform_tags property of this ProtectedBranch.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this ProtectedBranch.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'branch_name': 'str',
            'protection_levels': 'list[str]',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'branch_name': 'branchName',
            'protection_levels': 'protectionLevels',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._branch_name = None
        self._protection_levels = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def branch_name(self):
        """
        **[Required]** Gets the branch_name of this ProtectedBranch.
        The branchName can either be exact branch name or branch pattern.


        :return: The branch_name of this ProtectedBranch.
        :rtype: str
        """
        return self._branch_name

    @branch_name.setter
    def branch_name(self, branch_name):
        """
        Sets the branch_name of this ProtectedBranch.
        The branchName can either be exact branch name or branch pattern.


        :param branch_name: The branch_name of this ProtectedBranch.
        :type: str
        """
        self._branch_name = branch_name

    @property
    def protection_levels(self):
        """
        **[Required]** Gets the protection_levels of this ProtectedBranch.
        Protection levels to be added on the branch.

        Allowed values for items in this list are: "READ_ONLY", "PULL_REQUEST_MERGE_ONLY", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The protection_levels of this ProtectedBranch.
        :rtype: list[str]
        """
        return self._protection_levels

    @protection_levels.setter
    def protection_levels(self, protection_levels):
        """
        Sets the protection_levels of this ProtectedBranch.
        Protection levels to be added on the branch.


        :param protection_levels: The protection_levels of this ProtectedBranch.
        :type: list[str]
        """
        allowed_values = ["READ_ONLY", "PULL_REQUEST_MERGE_ONLY"]
        if protection_levels:
            protection_levels[:] = ['UNKNOWN_ENUM_VALUE' if not value_allowed_none_or_none_sentinel(x, allowed_values) else x for x in protection_levels]
        self._protection_levels = protection_levels

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this ProtectedBranch.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See `Resource Tags`__. Example: `{\"bar-key\": \"value\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this ProtectedBranch.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this ProtectedBranch.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.  See `Resource Tags`__. Example: `{\"bar-key\": \"value\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this ProtectedBranch.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this ProtectedBranch.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. See `Resource Tags`__. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this ProtectedBranch.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this ProtectedBranch.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. See `Resource Tags`__. Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this ProtectedBranch.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
